/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.manager;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.cloudier.client.CloudierClient;
import sila_java.library.cloudier.client.CloudierClientEndpoint;
import sila_java.library.cloudier.client.CloudierClientObserver;
import sila_java.library.core.discovery.SiLADiscovery;
import sila_java.library.core.encryption.EncryptionUtils;
import sila_java.library.core.encryption.SelfSignedCertificate;
import sila_java.library.core.sila.mapping.feature.FeatureGenerator;
import sila_java.library.core.sila.mapping.feature.MalformedSiLAFeature;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.utils.Utils;
import sila_java.library.manager.ServerAdditionException;
import sila_java.library.manager.ServerListener;
import sila_java.library.manager.executor.CallListener;
import sila_java.library.manager.executor.DefaultClientCallMetadataInjector;
import sila_java.library.manager.executor.ServerCallManager;
import sila_java.library.manager.models.CallCompleted;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.models.SiLACall;
import sila_java.library.manager.server_management.Connection;
import sila_java.library.manager.server_management.ServerConnectionException;
import sila_java.library.manager.server_management.ServerLoading;
import sila_java.library.server_base.config.ServerConfiguration;
import sila_java.library.server_base.identification.ServerInformation;

public class ServerManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ServerManager.class);
    private static final int MAX_SERVICE_TIMEOUT = 3;
    private static ServerManager instance;
    private final ServerCallManager serverCallManager = new ServerCallManager();
    private final SiLADiscovery discovery = new SiLADiscovery();
    private final Map<UUID, Connection> connections = new ConcurrentHashMap<UUID, Connection>();
    private final Map<UUID, Server> servers = new ConcurrentHashMap<UUID, Server>();
    private final List<ServerListener> serverListenerList = new CopyOnWriteArrayList<ServerListener>();
    private CloudierClient cloudierClient;
    private ClientInterceptor clientInterceptor = new DefaultClientCallMetadataInjector();
    private boolean allowUnsecureConnection = false;
    private X509Certificate rootCertificate = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerManager getInstance() {
        Class<ServerManager> clazz = ServerManager.class;
        synchronized (ServerManager.class) {
            if (instance == null) {
                instance = new ServerManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ServerManager() {
        try {
            this.cloudierClient = new CloudierClient(new CloudierClientEndpoint.CloudServerListener(){

                public void onAdd(UUID serverUUID, CloudierClientObserver cloudierClientObserver) {
                    CompletableFuture.runAsync(() -> {
                        boolean isNewServer;
                        Server server = new Server();
                        server.setJoined(new Date());
                        server.setHost("localhost");
                        server.setPort(50051);
                        server.setConnectionType(Server.ConnectionType.SERVER_INITIATED);
                        server.setStatus(Server.Status.ONLINE);
                        try {
                            CompletableFuture serverUUIDResponse = cloudierClientObserver.getOptionalServerUUID();
                            CompletableFuture serverName = cloudierClientObserver.getServerName();
                            CompletableFuture serverType = cloudierClientObserver.getServerType();
                            CompletableFuture serverDescription = cloudierClientObserver.getServerDescription();
                            CompletableFuture serverVendorURL = cloudierClientObserver.getServerVendorUrl();
                            CompletableFuture serverVersion = cloudierClientObserver.getServerVersion();
                            CompletableFuture features = cloudierClientObserver.getServerImplementedFeatures();
                            CompletableFuture.allOf(serverUUIDResponse, serverName, serverType, serverDescription, serverVendorURL, serverVersion, features).get(60L, TimeUnit.SECONDS);
                            UUID uuid = UUID.fromString(((SiLAServiceOuterClass.Get_ServerUUID_Responses)serverUUIDResponse.get()).getServerUUID().getValue());
                            server.setConfiguration(new ServerConfiguration(((SiLAServiceOuterClass.Get_ServerName_Responses)serverName.get()).getServerName().getValue(), uuid));
                            server.setNegotiationType(Server.NegotiationType.TLS);
                            server.setInformation(new ServerInformation(((SiLAServiceOuterClass.Get_ServerType_Responses)serverType.get()).getServerType().getValue(), ((SiLAServiceOuterClass.Get_ServerDescription_Responses)serverDescription.get()).getServerDescription().getValue(), ((SiLAServiceOuterClass.Get_ServerVendorURL_Responses)serverVendorURL.get()).getServerVendorURL().getValue(), ((SiLAServiceOuterClass.Get_ServerVersion_Responses)serverVersion.get()).getServerVersion().getValue()));
                            List<CompletableFuture> featuresDefinition = ((SiLAServiceOuterClass.Get_ImplementedFeatures_Responses)features.get()).getImplementedFeaturesList().stream().map(SiLAFramework.String::getValue).map(arg_0 -> ((CloudierClientObserver)cloudierClientObserver).getServerImplementedFeatures(arg_0)).collect(Collectors.toList());
                            CompletableFuture.allOf(featuresDefinition.toArray(new CompletableFuture[0])).get(60L, TimeUnit.SECONDS);
                            for (CompletableFuture f : featuresDefinition) {
                                SiLAServiceOuterClass.GetFeatureDefinition_Responses responses = (SiLAServiceOuterClass.GetFeatureDefinition_Responses)f.get();
                                String rawFeatureDefinition = Utils.cleanupXMLString((String)responses.getFeatureDefinition().getValue());
                                server.getFeatures().add(FeatureGenerator.generateFeature((String)rawFeatureDefinition));
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                            log.warn("Error while adding server", (Throwable)e);
                        }
                        UUID uuid = server.getConfiguration().getUuid();
                        Server serverInManager = (Server)ServerManager.this.servers.get(uuid);
                        boolean bl = isNewServer = serverInManager == null;
                        if (!isNewServer && serverInManager.getStatus() == Server.Status.ONLINE) {
                            log.warn("Server with id `{}` is already present in the manager and online! ", (Object)uuid);
                        }
                        try {
                            ServerManager.this.connections.put(uuid, new Connection(server, () -> {
                                log.info("Ended connection with server {}", (Object)serverUUID.toString());
                                cloudierClientObserver.close();
                            }));
                        }
                        catch (MalformedSiLAFeature e) {
                            e.printStackTrace();
                        }
                        if (isNewServer) {
                            ServerManager.this.servers.put(uuid, server);
                            ServerManager.this.serverListenerList.forEach(listener -> listener.onServerAdded(uuid, server));
                        } else {
                            serverInManager.setConnectionType(Server.ConnectionType.SERVER_INITIATED);
                            ServerManager.this.serverListenerList.forEach(listener -> listener.onServerChange(uuid, server));
                            ServerManager.this.servers.put(uuid, server);
                            ServerManager.this.serverListenerList.forEach(listener -> listener.onServerChange(uuid, server));
                        }
                    });
                }

                public void onEnd(Optional<UUID> optionalServerUUID, Optional<Throwable> t) {
                    String serverId = optionalServerUUID.map(UUID::toString).orElse("Unknown UUID");
                    if (t.isPresent()) {
                        log.error("Server initiated connection with server {} ended with an error", (Object)serverId, (Object)t.get());
                    } else {
                        log.warn("Server initiated connection with server {} has been closed", (Object)serverId);
                    }
                    optionalServerUUID.ifPresent(uuid -> ServerManager.this.setServerStatus(uuid, Server.Status.OFFLINE));
                }
            });
        }
        catch (IOException | CertificateEncodingException | SelfSignedCertificate.CertificateGenerationException e) {
            this.cloudierClient = null;
            log.error("Failed to start cloudier client", e);
        }
        this.discovery.addListener((instanceId, host, port, certificate) -> {
            String certificateStr;
            if (!this.allowUnsecureConnection && this.rootCertificate == null && !certificate.isPresent()) {
                log.warn("Unsafe connections to servers are not allowed! id: {}", (Object)instanceId);
                return;
            }
            if (this.rootCertificate != null || certificate.isPresent()) {
                String cnStr;
                X509Certificate x509Certificate = this.rootCertificate != null ? this.rootCertificate : (X509Certificate)certificate.get();
                try {
                    X500Name x500name = new JcaX509CertificateHolder(x509Certificate).getSubject();
                    RDN cn = x500name.getRDNs(BCStyle.CN)[0];
                    cnStr = cn.getFirst().getValue().toString();
                }
                catch (Exception e) {
                    log.debug("Unable to identify certificate common name", (Throwable)e);
                    return;
                }
                if (this.rootCertificate == null && !cnStr.equals("SiLA2")) {
                    log.debug("Untrusted server certificate first common name (CN) must be \"SiLA2\"");
                    return;
                }
                try {
                    certificateStr = EncryptionUtils.writeCertificateToString((X509Certificate)x509Certificate);
                }
                catch (IOException e) {
                    log.debug("Server with instance id: '{}' has an invalid certificate authority: '{}'", (Object)instanceId, (Object)e.getMessage());
                    return;
                }
            }
            certificateStr = null;
            try {
                Server server = this.servers.get(instanceId);
                if (server != null && server.getStatus() == Server.Status.ONLINE) {
                    log.debug("Discovery found server with uuid: " + instanceId);
                    return;
                }
                if (certificateStr != null) {
                    ServerManager.getInstance().addServer(host, port, certificateStr);
                } else {
                    ServerManager.getInstance().addServer(host, port);
                }
            }
            catch (ServerAdditionException e) {
                log.warn("Server with instance id: '{}' was not added because the following error occurred: '{}'", (Object)instanceId, (Object)e.getMessage());
            }
        });
        this.serverCallManager.addListener(new CallListener(){

            @Override
            public void onComplete(CallCompleted callCompleted) {
                String serverName;
                boolean isSetServerNameCall;
                SiLACall siLACall = callCompleted.getSiLACall();
                boolean bl = isSetServerNameCall = siLACall.getType().equals((Object)SiLACall.Type.UNOBSERVABLE_COMMAND) && siLACall.getFeatureId().equals("SiLAService") && siLACall.getCallId().equals("SetServerName");
                if (!isSetServerNameCall) {
                    return;
                }
                UUID serverId = siLACall.getServerId();
                try {
                    SiLAServiceOuterClass.SetServerName_Parameters.Builder builder = SiLAServiceOuterClass.SetServerName_Parameters.newBuilder();
                    JsonFormat.parser().merge(siLACall.getParameters(), (Message.Builder)builder);
                    serverName = builder.build().getServerName().getValue();
                }
                catch (Exception e) {
                    log.debug("Failed to parse & build set server name parameters: [{}]", (Object)siLACall.getParameters());
                    return;
                }
                Server server = (Server)ServerManager.this.servers.get(serverId);
                if (server == null) {
                    log.info("Cannot update server [{}] name since it is not present in the manager", (Object)serverId.toString());
                    return;
                }
                log.info("Server [{}] changed it's name to {}", (Object)serverId.toString(), (Object)serverName);
                server.setConfiguration(new ServerConfiguration(serverName, server.getConfiguration().getUuid()));
                ServerManager.this.serverListenerList.forEach(listener -> listener.onServerChange(serverId, server));
            }
        });
    }

    public void initialize(@NonNull Map<UUID, Server> silaServers) {
        if (silaServers == null) {
            throw new NullPointerException("silaServers is marked non-null but is null");
        }
        if (!this.connections.isEmpty() || !this.servers.isEmpty()) {
            throw new IllegalStateException("SiLA Manager can only be initialised in an empty state");
        }
        log.info("Initializing SiLA Manager with " + silaServers.size() + " servers");
        silaServers.forEach((uuid, server) -> {
            Connection connection;
            server.setStatus(Server.Status.OFFLINE);
            ManagedChannel managedChannel = server.getNegotiationType().equals((Object)Server.NegotiationType.TLS) ? this.getServerCallManager().newChannelBuilderWithEncryption(server.getHost(), server.getPort()).build() : this.getServerCallManager().newChannelBuilderWithoutEncryption(server.getHost(), server.getPort()).build();
            try {
                connection = new Connection((Server)server, managedChannel);
            }
            catch (MalformedSiLAFeature e) {
                managedChannel.shutdownNow();
                return;
            }
            this.servers.put((UUID)uuid, (Server)server);
            this.connections.put((UUID)uuid, connection);
            connection.attachAndTriggerListener(this::updateServerState);
        });
        log.info("Initialization complete");
    }

    public void clear() {
        this.servers.keySet().forEach(this::removeServer);
        this.discovery.clearCache();
    }

    @Override
    public void close() {
        this.discovery.close();
        this.connections.values().forEach(Connection::close);
        this.connections.clear();
        if (this.cloudierClient != null) {
            this.cloudierClient.close();
        }
        this.servers.clear();
        this.serverListenerList.clear();
        instance = null;
    }

    public synchronized void removeServer(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Connection connection = this.connections.get(id);
        Server server = this.servers.get(id);
        if (connection == null || server == null) {
            log.warn("Server with id: " + id + " already removed from cache.");
            return;
        }
        this.serverListenerList.forEach(listener -> listener.onServerRemoved(id, server));
        this.connections.remove(id);
        connection.close();
        this.servers.remove(id);
        log.info("[removeServer] removed serverId={}", (Object)id);
    }

    @Deprecated
    public synchronized void addServer(@NonNull String host, int port) throws ServerAdditionException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        Server server = new Server();
        server.setJoined(new Date());
        server.setHost(host);
        server.setPort(port);
        server.setConnectionType(Server.ConnectionType.CLIENT_INITIATED);
        server.setStatus(Server.Status.ONLINE);
        try {
            this.addServer(server);
        }
        catch (ServerAdditionException e) {
            this.serverListenerList.forEach(listener -> listener.onServerAdditionFail(host, port, e.getMessage()));
            throw e;
        }
    }

    public synchronized void addServer(@NonNull String host, int port, String certificate) throws ServerAdditionException {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        Server server = new Server();
        server.setJoined(new Date());
        server.setHost(host);
        server.setPort(port);
        server.setConnectionType(Server.ConnectionType.CLIENT_INITIATED);
        server.setStatus(Server.Status.ONLINE);
        server.setCertificateAuthority(certificate);
        try {
            this.addServer(server);
        }
        catch (ServerAdditionException e) {
            this.serverListenerList.forEach(listener -> listener.onServerAdditionFail(host, port, e.getMessage()));
            throw e;
        }
    }

    private void addServer(@NonNull Server server) throws ServerAdditionException {
        Connection connection;
        boolean isNewServer;
        ManagedChannel managedChannel;
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        try {
            managedChannel = ServerLoading.attemptConnectionWithServer(server, Optional.ofNullable(this.clientInterceptor), this.allowUnsecureConnection, !this.allowUnsecureConnection ? EncryptionUtils.readCertificate((String)server.getCertificateAuthority()) : null);
        }
        catch (IOException | ServerConnectionException e) {
            throw new ServerAdditionException(server, e.getMessage());
        }
        try {
            ServerLoading.loadServer(server, managedChannel);
        }
        catch (ServerLoading.ServerLoadingException e) {
            managedChannel.shutdownNow();
            throw new ServerAdditionException(server, e.getMessage());
        }
        log.info("[addServer] Resolved SiLA Server serverName={} on {}:{}", new Object[]{server.getConfiguration().getName(), server.getHost(), server.getPort()});
        UUID uuid = server.getConfiguration().getUuid();
        Server serverInManager = this.servers.get(uuid);
        boolean bl = isNewServer = serverInManager == null;
        if (!isNewServer && serverInManager.getStatus() == Server.Status.ONLINE) {
            log.warn("Server with id `{}` is already present in the manager and online! ", (Object)uuid);
            managedChannel.shutdownNow();
            throw new ServerAdditionException(server, "Server with id [" + uuid + "] is already in the manager and online");
        }
        try {
            connection = new Connection(server, managedChannel);
        }
        catch (MalformedSiLAFeature e) {
            managedChannel.shutdownNow();
            throw new ServerAdditionException(server, e.getMessage());
        }
        this.servers.put(uuid, server);
        Connection previousConnection = this.connections.put(uuid, connection);
        if (previousConnection != null) {
            previousConnection.close();
        }
        if (isNewServer) {
            this.serverListenerList.forEach(listener -> listener.onServerAdded(uuid, server));
        } else {
            this.serverListenerList.forEach(listener -> listener.onServerChange(uuid, server));
        }
        connection.attachAndTriggerListener(this::updateServerState);
    }

    private void updateServerState(@NonNull UUID serverId, @NonNull ManagedChannel channel) {
        if (serverId == null) {
            throw new NullPointerException("serverId is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        Server server = this.servers.get(serverId);
        if (server == null) {
            log.warn("Unable to update server state because server {} does not exist", (Object)serverId);
            return;
        }
        if (server.getConnectionType().equals((Object)Server.ConnectionType.SERVER_INITIATED)) {
            log.warn("No need to manually check server {} state in server initiated mode", (Object)serverId);
            return;
        }
        ConnectivityState state = channel.getState(false);
        if (state == ConnectivityState.IDLE) {
            CompletableFuture.runAsync(() -> {
                Server.Status status = Server.Status.OFFLINE;
                try {
                    UUID uuid = ServerLoading.getServerId(SiLAServiceGrpc.newBlockingStub((Channel)channel));
                    if (server.getConfiguration().getUuid().equals(uuid)) {
                        status = Server.Status.ONLINE;
                    } else {
                        log.debug("GetServerId returned by server UUID: {} differ from the one in manager {}", (Object)uuid, (Object)server.getConfiguration().getUuid());
                    }
                }
                catch (Exception e) {
                    log.debug("Failed UUID Retrieval {}", (Object)e.getMessage());
                }
                if (server.getConnectionType().equals((Object)Server.ConnectionType.SERVER_INITIATED)) {
                    log.warn("No need to manually check server {} state in server initiated mode", (Object)serverId);
                    return;
                }
                this.setServerStatus(serverId, status);
            });
        }
    }

    private void setServerStatus(@NonNull UUID id, @NonNull Server.Status status) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        Connection siLAConnection = this.connections.get(id);
        if (siLAConnection == null) {
            log.warn("Server with id " + id + " doesn't exist.");
            return;
        }
        Server server = this.servers.get(id);
        if (!server.getStatus().equals((Object)status)) {
            server.setStatus(status);
            log.info("[changeServerStatus] change {} status to {}", (Object)id, (Object)status);
            this.serverListenerList.forEach(listener -> listener.onServerChange(id, server));
        }
    }

    public void setServerName(@NonNull UUID id, @NonNull String newServerName) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (newServerName == null) {
            throw new NullPointerException("newServerName is marked non-null but is null");
        }
        Connection connection = this.connections.get(id);
        if (connection == null) {
            log.warn("Server with id " + id + " doesn't exit.");
            return;
        }
        Server server = this.servers.get(id);
        if (!server.getConfiguration().getName().equals(newServerName)) {
            log.info("[setServerName] server name changed to {}", (Object)newServerName);
            @NonNull ManagedChannel managedChannel = connection.getManagedChannel();
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull SiLAServiceGrpc.SiLAServiceBlockingStub siLAServiceBlockingStub = SiLAServiceGrpc.newBlockingStub((Channel)managedChannel);
            ((SiLAServiceGrpc.SiLAServiceBlockingStub)siLAServiceBlockingStub.withDeadlineAfter(3L, TimeUnit.SECONDS)).setServerName(SiLAServiceOuterClass.SetServerName_Parameters.newBuilder().setServerName(SiLAString.from((String)newServerName)).build());
            String serverName = ServerLoading.getServerName(siLAServiceBlockingStub);
            if (serverName.equals(newServerName)) {
                log.info("[setServerName] server name changed to {}", (Object)newServerName);
                server.setConfiguration(new ServerConfiguration(newServerName, server.getConfiguration().getUuid()));
                this.serverListenerList.forEach(listener -> listener.onServerChange(id, server));
            } else {
                throw new IllegalStateException("Server Name was not updated on SiLA Server.");
            }
        }
    }

    public Map<UUID, Server> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }

    public synchronized Map<UUID, Connection> getConnections() {
        return Collections.unmodifiableMap(this.connections);
    }

    public void addServerListener(@NonNull ServerListener siLAServerListener) {
        if (siLAServerListener == null) {
            throw new NullPointerException("siLAServerListener is marked non-null but is null");
        }
        this.serverListenerList.add(siLAServerListener);
    }

    public void removeServerListener(@NonNull ServerListener siLAServerListener) {
        if (siLAServerListener == null) {
            throw new NullPointerException("siLAServerListener is marked non-null but is null");
        }
        this.serverListenerList.remove(siLAServerListener);
    }

    public ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    public void setClientInterceptor(ClientInterceptor clientInterceptor) {
        this.clientInterceptor = clientInterceptor;
    }

    public ServerCallManager getServerCallManager() {
        return this.serverCallManager;
    }

    public SiLADiscovery getDiscovery() {
        return this.discovery;
    }

    public CloudierClient getCloudierClient() {
        return this.cloudierClient;
    }

    public boolean isAllowUnsecureConnection() {
        return this.allowUnsecureConnection;
    }

    public void setAllowUnsecureConnection(boolean allowUnsecureConnection) {
        this.allowUnsecureConnection = allowUnsecureConnection;
    }

    public X509Certificate getRootCertificate() {
        return this.rootCertificate;
    }

    public void setRootCertificate(X509Certificate rootCertificate) {
        this.rootCertificate = rootCertificate;
    }
}

