/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.config.ServerConfiguration;

public class PersistentServerConfigWrapper
implements IServerConfigWrapper {
    private static final Logger log = LoggerFactory.getLogger(PersistentServerConfigWrapper.class);
    private final Gson gson;
    private final File dbFile;
    private ServerConfiguration configuration;

    public PersistentServerConfigWrapper(@NonNull Path configFile, @NonNull String defaultName) throws IOException {
        if (configFile == null) {
            throw new NullPointerException("configFile");
        }
        if (defaultName == null) {
            throw new NullPointerException("defaultName");
        }
        this.dbFile = this.setupConfigFile(configFile);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            this.retrieveConfiguration();
        }
        catch (RuntimeException e) {
            log.info("No existing Server Configuration found.");
            this.setConfig(ServerConfiguration.generateDefault(defaultName));
        }
        if (this.configuration == null) {
            log.error("Unable to use and or save config file at " + configFile);
            throw new IOException("Cannot use and or save config in file " + configFile);
        }
    }

    @Override
    public ServerConfiguration getCacheConfig() {
        if (this.configuration == null) {
            throw new IllegalStateException("Server Configuration not yet loaded, use retrieveConfiguration!");
        }
        return this.configuration;
    }

    @Override
    public void setConfig(@NonNull ServerConfiguration serverConfiguration) throws IOException {
        if (serverConfiguration == null) {
            throw new NullPointerException("serverConfiguration");
        }
        this.configuration = serverConfiguration;
        log.info("Setting serverId: {} and serverName: {}", (Object)this.configuration.getUuid(), (Object)this.configuration.getName());
        this.writeConfiguration();
    }

    private void writeConfiguration() throws IOException {
        try (FileWriter writer = new FileWriter(this.dbFile);){
            this.gson.toJson((Object)this.configuration, (Appendable)writer);
            writer.flush();
        }
    }

    private void retrieveConfiguration() {
        try (FileReader reader = new FileReader(this.dbFile);){
            ServerConfiguration serverConfiguration = (ServerConfiguration)this.gson.fromJson((Reader)reader, ServerConfiguration.class);
            if (serverConfiguration.getName() == null || serverConfiguration.getUuid() == null) {
                throw new JsonParseException("At least one of the config parameters has no value.");
            }
            this.configuration = serverConfiguration;
        }
        catch (IOException e) {
            throw new RuntimeException("Internal Logic error, persistence file not created.");
        }
    }

    private File setupConfigFile(@NonNull Path configFile) throws IOException {
        if (configFile == null) {
            throw new NullPointerException("configFile");
        }
        File dbFile = configFile.toFile();
        if (!dbFile.exists()) {
            dbFile.getParentFile().mkdirs();
            if (!dbFile.createNewFile()) {
                throw new IOException("Failed to create config file: " + dbFile);
            }
            Files.write(dbFile.toPath(), "{}".getBytes(), new OpenOption[0]);
        }
        return dbFile;
    }
}

