/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.discovery.SiLAServerRegistration;
import sila_java.library.server_base.SiLAServiceServer;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.config.NonPersistentServerConfigWrapper;
import sila_java.library.server_base.config.PersistentServerConfigWrapper;
import sila_java.library.server_base.identification.ServerInformation;

public class SiLAServerBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SiLAServerBase.class);
    private static final int SHUTDOWN_TIMEOUT = 20;
    private final SiLAServerRegistration serverRegistration = new SiLAServerRegistration();
    private final Server server;

    public static SiLAServerBase withoutConfig(@NonNull ServerInformation serverInformation, @NonNull Map<String, String> featureDefinitions, int port, @NonNull String interfaceName, BindableService ... bindableServices) throws IOException {
        if (serverInformation == null) {
            throw new NullPointerException("serverInformation");
        }
        if (featureDefinitions == null) {
            throw new NullPointerException("featureDefinitions");
        }
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        log.debug("Server config is non-persistent");
        return new SiLAServerBase(new NonPersistentServerConfigWrapper(serverInformation.getType()), serverInformation, featureDefinitions, port, interfaceName, bindableServices);
    }

    public static SiLAServerBase withConfig(@NonNull Path configurationFile, @NonNull ServerInformation serverInformation, @NonNull Map<String, String> featureDefinitions, int port, @NonNull String interfaceName, BindableService ... bindableServices) throws IOException {
        if (configurationFile == null) {
            throw new NullPointerException("configurationFile");
        }
        if (serverInformation == null) {
            throw new NullPointerException("serverInformation");
        }
        if (featureDefinitions == null) {
            throw new NullPointerException("featureDefinitions");
        }
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        log.debug("Server config is persistent");
        return new SiLAServerBase(new PersistentServerConfigWrapper(configurationFile, serverInformation.getType()), serverInformation, featureDefinitions, port, interfaceName, bindableServices);
    }

    @Override
    public void close() {
        log.info("[stop] stopping server...");
        this.serverRegistration.unregisterServer();
        if (this.server != null && !this.server.isTerminated() && !this.server.isShutdown()) {
            try {
                log.info("[stop] stopping the server ...");
                this.server.shutdownNow().awaitTermination(20L, TimeUnit.SECONDS);
                log.info("[stop] the server was stopped");
            }
            catch (InterruptedException e) {
                log.warn("[stop] could not shutdown the server within {} seconds", (Object)20);
            }
            log.info("[stop] stopped");
        } else {
            log.info("[stop] server already stopped");
        }
    }

    private SiLAServerBase(@NonNull IServerConfigWrapper serverConfig, @NonNull ServerInformation serverInformation, @NonNull Map<String, String> featureDefinitions, int port, @NonNull String interfaceName, BindableService ... bindableServices) throws IOException {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig");
        }
        if (serverInformation == null) {
            throw new NullPointerException("serverInformation");
        }
        if (featureDefinitions == null) {
            throw new NullPointerException("featureDefinitions");
        }
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        SiLAServiceServer siLAServiceServer = new SiLAServiceServer(serverConfig, serverInformation, featureDefinitions);
        log.info("[withoutConfig] Server registered on SiLAService with features={}", featureDefinitions.keySet());
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)port).addService(siLAServiceServer.getService());
        Arrays.stream(bindableServices).forEach(arg_0 -> ((ServerBuilder)serverBuilder).addService(arg_0));
        this.server = serverBuilder.build().start();
        log.info("[withoutConfig] Server started on port={}", (Object)port);
        this.serverRegistration.registerServer(serverConfig.getCacheConfig().getUuid(), interfaceName, port);
        log.info("[withoutConfig] Server registered with discovery.");
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }
}

