/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base;

import com.google.gson.JsonObject;
import io.grpc.BindableService;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.core.utils.SiLAErrors;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.identification.ServerInformation;

public class SiLAServiceServer {
    private static final Logger log = LoggerFactory.getLogger(SiLAServiceServer.class);
    private final Map<String, String> featureDefinitions = new HashMap<String, String>();
    private final IServerConfigWrapper serverConfigurationContainer;
    private final ServerInformation serverInformation;

    public SiLAServiceServer(@NonNull IServerConfigWrapper serverConfigurationContainer, @Nonnull ServerInformation serverInformation, @Nonnull Map<String, String> featureDefinitions) {
        if (serverConfigurationContainer == null) {
            throw new NullPointerException("serverConfigurationContainer");
        }
        this.serverConfigurationContainer = serverConfigurationContainer;
        this.serverInformation = serverInformation;
        log.info("[SiLAService] create service for: {}\nfeatureDefinitions={} ...", (Object)serverInformation, featureDefinitions.keySet());
        for (String key : featureDefinitions.keySet()) {
            try {
                String featureDefinition = featureDefinitions.get(key);
                Utils.validateFeatureXML((Source)new StreamSource(new StringReader(featureDefinition)));
                this.featureDefinitions.put(key, featureDefinition);
                log.info("[registerServer] type={} feature={} is read from XML string.", (Object)serverInformation.getType(), (Object)key);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error registering feature definition for server = " + serverInformation.getType() + "& feature = '" + key + "' is not valid", e);
            }
        }
        log.info("[registerServer] server type = {} with features successfully registered!", (Object)serverInformation.getType());
    }

    public BindableService getService() {
        return new ServiceImpl();
    }

    private class ServiceImpl
    extends SiLAServiceGrpc.SiLAServiceImplBase {
        private ServiceImpl() {
        }

        @Override
        public void getFeatureDefinition(@NonNull SiLAServiceOuterClass.GetFeatureDefinition_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.GetFeatureDefinition_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver");
            }
            String featureIdentifier = req.getQualifiedFeatureIdentifier().getFeatureIdentifier().getValue();
            String serverName = SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getName();
            log.info("[{}][getFeatureDefinition] feature={} entered.", (Object)serverName, (Object)featureIdentifier);
            String featureDefinitionContent = (String)SiLAServiceServer.this.featureDefinitions.get(featureIdentifier);
            if (featureDefinitionContent == null) {
                JsonObject validationError = new JsonObject();
                validationError.addProperty("Parameter", "FeatureIdentifier");
                validationError.addProperty("Message", "Feature definition for " + featureIdentifier + " doesn't exist,  existing Features: " + SiLAServiceServer.this.featureDefinitions.keySet());
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT.withDescription(validationError.toString())));
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.GetFeatureDefinition_Responses.newBuilder().setFeatureDefinition(SiLAServiceOuterClass.DataType_FeatureDefinition.newBuilder().setFeatureDefinition(SiLAFramework.String.newBuilder().setValue(featureDefinitionContent).build()).build()).build());
            responseObserver.onCompleted();
            log.info("[{}][getFeatureDefinition] feature={} returned={}.", new Object[]{serverName, featureIdentifier, featureDefinitionContent});
        }

        @Override
        public void setServerName(SiLAServiceOuterClass.SetServerName_Parameters req, StreamObserver<SiLAServiceOuterClass.SetServerName_Responses> responseObserver) {
            String serverName = req.getServerName().getValue();
            log.info("setServerName being called, Server Name: {}", (Object)serverName);
            try {
                SiLAServiceServer.this.serverConfigurationContainer.setConfig(SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().withName(serverName));
                responseObserver.onNext((Object)SiLAServiceOuterClass.SetServerName_Responses.newBuilder().build());
                responseObserver.onCompleted();
            }
            catch (IOException e) {
                StatusRuntimeException error = SiLAErrors.generateGenericExecutionError((Exception)e);
                responseObserver.onError((Throwable)error);
            }
        }

        @Override
        public void getServerName(SiLAServiceOuterClass.Get_ServerName_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerName_Responses> responseObserver) {
            log.info("getServerName being called");
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerName_Responses.newBuilder().setServerName(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getName()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerType(SiLAServiceOuterClass.Get_ServerType_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerType_Responses> responseObserver) {
            log.info("getServerType being called");
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerType_Responses.newBuilder().setServerType(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverInformation.getType()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerUUID(SiLAServiceOuterClass.Get_ServerUUID_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerUUID_Responses> responseObserver) {
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerUUID_Responses.newBuilder().setServerUUID(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getUuid().toString()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerDescription(@NonNull SiLAServiceOuterClass.Get_ServerDescription_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerDescription_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver");
            }
            log.info("getServerDescription being called");
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerDescription_Responses.newBuilder().setServerDescription(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverInformation.getDescription()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerVersion(@NonNull SiLAServiceOuterClass.Get_ServerVersion_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerVersion_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver");
            }
            log.info("getServerVersion being called");
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerVersion_Responses.newBuilder().setServerVersion(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverInformation.getVersion()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerVendorURL(@NonNull SiLAServiceOuterClass.Get_ServerVendorURL_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerVendorURL_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver");
            }
            log.info("getServerVendorName being called");
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerVendorURL_Responses.newBuilder().setServerVendorURL(SiLAServiceOuterClass.DataType_URL.newBuilder().setURL(SiLAFramework.String.newBuilder().setValue(SiLAServiceServer.this.serverInformation.getVendorURL()).build()).build()).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getImplementedFeatures(@NonNull SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ImplementedFeatures_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver");
            }
            log.info("getImplementedFeatures being called");
            SiLAServiceOuterClass.Get_ImplementedFeatures_Responses.Builder idBuilder = SiLAServiceOuterClass.Get_ImplementedFeatures_Responses.newBuilder();
            SiLAServiceServer.this.featureDefinitions.keySet().forEach(featureId -> idBuilder.addImplementedFeatures(SiLAServiceOuterClass.DataType_FeatureIdentifier.newBuilder().setFeatureIdentifier(SiLAFramework.String.newBuilder().setValue((String)featureId).build()).build()));
            responseObserver.onNext((Object)idBuilder.build());
            responseObserver.onCompleted();
        }
    }
}

