/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.NonNull;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import sila_java.library.core.communication.utils.ListNetworkInterfaces;

public class ArgumentHelper {
    private final ArgumentParser parser;
    private final String[] args;
    private final Namespace ns;

    public ArgumentHelper(@NonNull String[] args, @NonNull String serverName) {
        this(args, serverName, null);
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
    }

    public ArgumentHelper(@NonNull String[] args, @NonNull String serverName, ArgumentParser baseParser) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName");
        }
        this.args = args;
        this.parser = baseParser == null ? ArgumentParsers.newFor((String)serverName).build().defaultHelp(true).description("SiLA Server.") : baseParser;
        this.parser.addArgument(new String[]{"-p", "--port"}).type(Integer.class).help("Specify port to use.");
        this.parser.addArgument(new String[]{"-n", "--networkInterface"}).type(String.class).setDefault((Object)"local").help("Specify network interface. Check ifconfig (LNX & MAC) and for windows, ask us for a tiny java app @ www.unitelabs.ch .");
        this.parser.addArgument(new String[]{"-c", "--configFile"}).type(String.class).help("Specify the file name to use to read/store server information");
        this.parser.addArgument(new String[]{"-l", "--listNetworks"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("List names of network interfaces found.");
        this.ns = this.parser.parseArgsOrFail(args);
        if (this.ns.getBoolean("listNetworks").booleanValue()) {
            ListNetworkInterfaces.display();
            System.exit(0);
        }
    }

    public Integer getPort() {
        return this.ns.getInt("port");
    }

    public String getInterface() {
        return this.ns.getString("networkInterface");
    }

    public Optional<Path> getConfigFile() {
        String configFile = this.ns.getString("configFile");
        if (configFile == null) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(configFile, new String[0]));
    }

    public String[] getArgs() {
        return this.args;
    }

    public Namespace getNs() {
        return this.ns;
    }
}

