/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.download;

import com.google.protobuf.ByteString;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.core.sila.binary_transfer.BinaryInfo;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.types.SiLABinaryTransferUUID;
import sila_java.library.core.sila.types.SiLADuration;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;

public class DownloadService
extends BinaryDownloadGrpc.BinaryDownloadImplBase {
    private static final Logger log = LoggerFactory.getLogger(DownloadService.class);
    static final int MAX_CHUNK_SIZE = 0x200000;
    private final BinaryDatabase binaryDatabase;

    public void getBinaryInfo(SiLABinaryTransfer.GetBinaryInfoRequest request, StreamObserver<SiLABinaryTransfer.GetBinaryInfoResponse> responseObserver) {
        try {
            BinaryInfo binaryInfo;
            UUID binaryTransferUuid = SiLABinaryTransferUUID.from((String)request.getBinaryTransferUUID());
            this.throwIfBinaryNotExist(binaryTransferUuid);
            try {
                binaryInfo = this.binaryDatabase.getBinaryInfo(UUID.fromString(request.getBinaryTransferUUID()));
            }
            catch (Exception e) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)e.getMessage());
            }
            responseObserver.onNext((Object)SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder().setBinarySize(binaryInfo.getLength()).setLifetimeOfBinary(SiLADuration.from((Duration)Duration.between(OffsetDateTime.now(), binaryInfo.getExpiration()))).build());
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onCompleted();
    }

    public StreamObserver<SiLABinaryTransfer.GetChunkRequest> getChunk(final StreamObserver<SiLABinaryTransfer.GetChunkResponse> responseObserver) {
        return new StreamObserver<SiLABinaryTransfer.GetChunkRequest>(){

            public void onNext(SiLABinaryTransfer.GetChunkRequest request) {
                DownloadService.this.getChunk(request, (StreamObserver<SiLABinaryTransfer.GetChunkResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                log.warn("Download chunk stream exception: {}", (Object)t.getMessage(), (Object)t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private void getChunk(SiLABinaryTransfer.GetChunkRequest request, StreamObserver<SiLABinaryTransfer.GetChunkResponse> responseObserver) {
        try {
            UUID id = SiLABinaryTransferUUID.from((String)request.getBinaryTransferUUID());
            this.throwIfBinaryNotExist(id);
            if (request.getLength() > 0x200000) {
                responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_DOWNLOAD_FAILED, (String)"Chunk size must not be larger than 2 MiB."));
            }
            try {
                Duration extendedExpiration = this.binaryDatabase.extendBinaryExpiration(id);
                Binary binary = this.binaryDatabase.getBinary(id);
                responseObserver.onNext((Object)SiLABinaryTransfer.GetChunkResponse.newBuilder().setPayload(ByteString.readFrom((InputStream)binary.getData().getBinaryStream(request.getOffset() + 1L, request.getLength()))).setOffset(request.getOffset()).setBinaryTransferUUID(request.getBinaryTransferUUID()).setLifetimeOfBinary(SiLADuration.from((Duration)extendedExpiration)).build());
            }
            catch (Exception e) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_DOWNLOAD_FAILED, (String)e.getMessage());
            }
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void deleteBinary(SiLABinaryTransfer.DeleteBinaryRequest request, StreamObserver<SiLABinaryTransfer.DeleteBinaryResponse> responseObserver) {
        try {
            UUID binaryTransferUuid = SiLABinaryTransferUUID.from((String)request.getBinaryTransferUUID());
            this.throwIfBinaryNotExist(binaryTransferUuid);
            try {
                this.binaryDatabase.removeBinary(binaryTransferUuid);
            }
            catch (Exception e) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)e.getMessage());
            }
            responseObserver.onNext((Object)SiLABinaryTransfer.DeleteBinaryResponse.newBuilder().build());
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onCompleted();
    }

    private void throwIfBinaryNotExist(@Nullable UUID binaryTransferUUID) throws StatusRuntimeException {
        boolean exist = false;
        try {
            exist = this.binaryDatabase.hasBinary(binaryTransferUUID);
        }
        catch (BinaryDatabaseException binaryDatabaseException) {
            // empty catch block
        }
        if (!exist) {
            throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)"Invalid Binary Transfer UUID.");
        }
    }

    public DownloadService(BinaryDatabase binaryDatabase) {
        this.binaryDatabase = binaryDatabase;
    }
}

