/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UploadCompletion
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(UploadCompletion.class);
    private static final String CHUNK_FILE_EXT = ".chunk";
    private final SortedMap<Integer, File> chunks = new TreeMap(Comparator.naturalOrder());
    private final long totalLength;
    private final int totalChunks;
    private final String parameterIdentifier;

    UploadCompletion(long totalLength, int nbChunk, String parameterIdentifier) {
        this.totalLength = totalLength;
        this.totalChunks = nbChunk;
        this.parameterIdentifier = parameterIdentifier;
    }

    void addChunk(int chunkIndex, byte[] data) throws IOException {
        if (this.isComplete()) {
            throw new IllegalStateException("Download is complete");
        }
        if (chunkIndex < 0 || chunkIndex >= this.totalChunks) {
            throw new IllegalArgumentException("Invalid chunk index `" + chunkIndex + "`");
        }
        if (this.getTotalChunksLength() + (long)data.length > this.totalLength) {
            throw new IllegalArgumentException("Too much data uploaded.");
        }
        if (this.chunks.containsKey(chunkIndex)) {
            throw new IllegalArgumentException("Chunk index " + chunkIndex + " already uploaded");
        }
        File previousEntry = this.chunks.put(chunkIndex, UploadCompletion.saveChunkToFile(data));
        if (previousEntry != null) {
            previousEntry.delete();
        }
    }

    boolean isComplete() {
        return this.chunks.size() == this.totalChunks;
    }

    boolean matchLength() {
        return this.totalLength == this.getTotalChunksLength();
    }

    private long getTotalChunksLength() {
        return this.chunks.values().stream().mapToLong(File::length).sum();
    }

    InputStream chunksToStream() throws IOException {
        ArrayList<FileInputStream> streams = new ArrayList<FileInputStream>(this.chunks.size());
        try {
            for (Map.Entry<Integer, File> entry : this.chunks.entrySet()) {
                streams.add(entry.getKey(), new FileInputStream(entry.getValue()));
            }
        }
        catch (FileNotFoundException e) {
            for (InputStream inputStream : streams) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    log.debug("Exception occurred while closing inputstream: {}", (Object)e1.getMessage(), (Object)e1);
                }
            }
            throw new IOException(e);
        }
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    private static File saveChunkToFile(byte[] data) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), CHUNK_FILE_EXT);
        tempFile.deleteOnExit();
        try {
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        }
        catch (IOException e) {
            tempFile.delete();
            throw e;
        }
        return tempFile;
    }

    @Override
    public void close() {
        this.chunks.values().forEach(File::delete);
        this.chunks.clear();
    }

    SortedMap<Integer, File> getChunks() {
        return this.chunks;
    }

    long getTotalLength() {
        return this.totalLength;
    }

    int getTotalChunks() {
        return this.totalChunks;
    }

    String getParameterIdentifier() {
        return this.parameterIdentifier;
    }
}

