/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.command.observable;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.ObservableCommandWrapper;
import sila_java.library.server_base.command.observable.RunnableCommandTask;

public class ObservableCommandManager<ParamType, ResultType>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandManager.class);
    private static final int EXPIRED_COMMAND_CLEANUP_INTERVAL_SEC = 10;
    private static final Set<ObservableCommandManager<?, ?>> Instances = ConcurrentHashMap.newKeySet();
    private static final ScheduledExecutorService ScheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<UUID, ObservableCommandWrapper<ParamType, ResultType>> commands = new ConcurrentHashMap<UUID, ObservableCommandWrapper<ParamType, ResultType>>();
    private final RunnableCommandTask<ParamType, ResultType> task;
    private final ObservableCommandTaskRunner runner;
    private final Duration lifeTimeOfCommandExecution;

    public ObservableCommandManager(@NonNull ObservableCommandTaskRunner taskRunner, @NonNull RunnableCommandTask<ParamType, ResultType> task) {
        this(taskRunner, task, null);
        if (taskRunner == null) {
            throw new NullPointerException("taskRunner is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    public ObservableCommandManager(@NonNull ObservableCommandTaskRunner taskRunner, @NonNull RunnableCommandTask<ParamType, ResultType> task, @Nullable Duration lifeTimeOfCommandExecution) {
        if (taskRunner == null) {
            throw new NullPointerException("taskRunner is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (lifeTimeOfCommandExecution != null && (lifeTimeOfCommandExecution.isNegative() || lifeTimeOfCommandExecution.isZero())) {
            throw new IllegalArgumentException("LifeTimeOfCommandExecution duration must be greater than 0");
        }
        this.task = task;
        this.runner = taskRunner;
        this.lifeTimeOfCommandExecution = lifeTimeOfCommandExecution;
        Instances.add(this);
    }

    public ObservableCommandWrapper<ParamType, ResultType> addCommand(@NonNull ParamType param, @NonNull StreamObserver<SiLAFramework.CommandConfirmation> observer) throws StatusRuntimeException {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        try {
            this.task.validate(param);
        }
        catch (Exception e) {
            if (e instanceof StatusRuntimeException) {
                throw e;
            }
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
        try {
            ObservableCommandWrapper<ParamType, ResultType> command = new ObservableCommandWrapper<ParamType, ResultType>(param, this.task, this.runner, this.lifeTimeOfCommandExecution);
            this.notifyNewConcurrentCommand(command);
            this.commands.put(command.getExecutionId(), command);
            if (observer instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)observer).setOnCancelHandler(() -> this.remove(command.getExecutionId()));
            } else {
                log.warn("Current stream observer implementation does not allow to check reception of command UUID");
            }
            observer.onNext((Object)command.getCommandConfirmation());
            observer.onCompleted();
            return command;
        }
        catch (RejectedExecutionException e) {
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
    }

    public ObservableCommandWrapper<ParamType, ResultType> get(@NonNull SiLAFramework.CommandExecutionUUID executionId) throws StatusRuntimeException {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        return this.get(this.validateAndGetUUID(executionId));
    }

    public ObservableCommandWrapper<ParamType, ResultType> get(@NonNull UUID executionId) throws StatusRuntimeException {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        ObservableCommandWrapper<ParamType, ResultType> command = this.commands.get(executionId);
        if (command == null) {
            throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_COMMAND_EXECUTION_UUID, (String)"The Command Execution UUID is not valid. There is no command executed with the UUID.");
        }
        return command;
    }

    @Override
    public void close() {
        this.commands.values().forEach(ObservableCommandWrapper::close);
        this.commands.clear();
        this.runner.close();
        Instances.remove(this);
    }

    public void remove(@NonNull UUID executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        ObservableCommandWrapper<ParamType, ResultType> command = this.commands.get(executionId);
        if (command != null) {
            try {
                this.commands.remove(executionId);
            }
            finally {
                command.close();
            }
        }
    }

    private void notifyNewConcurrentCommand(@NonNull ObservableCommandWrapper<ParamType, ResultType> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.commands.values().forEach(c -> c.getTask().onNewCommand(command));
    }

    private UUID validateAndGetUUID(@Nullable SiLAFramework.CommandExecutionUUID executionUUID) throws StatusRuntimeException {
        try {
            if (executionUUID == null) {
                throw new NullPointerException();
            }
            return UUID.fromString(executionUUID.getValue());
        }
        catch (Exception e) {
            throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_COMMAND_EXECUTION_UUID, (String)"Invalid Command Execution UUID.");
        }
    }

    private static void cleanupExpiredCommands() {
        try {
            for (ObservableCommandManager<?, ?> instance : Instances) {
                HashSet<UUID> commandsToRemove = new HashSet<UUID>();
                for (ObservableCommandWrapper command : instance.commands.values()) {
                    if (!command.isExpired()) continue;
                    commandsToRemove.add(command.getExecutionId());
                }
                for (UUID executionId : commandsToRemove) {
                    try {
                        log.debug("Cleaning up observable command wrapper {}", (Object)executionId);
                        instance.remove(executionId);
                    }
                    catch (Exception e) {
                        log.warn("Failed to cleanup observable command wrapper " + executionId, (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.warn("An unknown error occurred while cleanup expired observable commands.", e);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ScheduledExecutor::shutdown));
        ScheduledExecutor.scheduleWithFixedDelay(ObservableCommandManager::cleanupExpiredCommands, 10L, 10L, TimeUnit.SECONDS);
    }
}

