/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.standard_features;

import io.grpc.BindableService;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.core.lockcontroller.v1.LockControllerGrpc;
import sila2.org.silastandard.core.lockcontroller.v1.LockControllerOuterClass;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLABoolean;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.sila_base.EmptyClass;

public class LockController
extends LockControllerGrpc.LockControllerImplBase
implements FeatureImplementation,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LockController.class);
    private static final String FULLY_QUALIFIED_FEATURE_IDENTIFIER = "org.silastandard/core/LockController/v1";
    private static final String INVALID_LOCK_IDENTIFIER = "InvalidLockIdentifier";
    private static final String SERVER_NOT_LOCKED = "ServerNotLocked";
    private static final String SERVER_ALREADY_LOCKED = "ServerAlreadyLocked";
    private final Timer lockTimer = new Timer();
    private String lockIdentifier;

    @Override
    public void lockServer(LockControllerOuterClass.LockServer_Parameters request, StreamObserver<LockControllerOuterClass.LockServer_Responses> responseObserver) {
        if (StringUtils.isNotEmpty((CharSequence)this.lockIdentifier)) {
            this.respondWithError(responseObserver, SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/LockController/v1/DefinedExecutionError/ServerAlreadyLocked", (String)"server already locked"));
            return;
        }
        if (!request.hasLockIdentifier()) {
            this.respondWithError(responseObserver, SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/LockController/v1/DefinedExecutionError/InvalidLockIdentifier", (String)"lockIdentifier required"));
            return;
        }
        if (request.hasTimeout()) {
            this.handleLockServer(request.getLockIdentifier().getValue(), request.getTimeout().getValue());
        } else {
            this.handleLockServer(request.getLockIdentifier().getValue());
        }
        responseObserver.onCompleted();
    }

    @Override
    public void unlockServer(LockControllerOuterClass.UnlockServer_Parameters request, StreamObserver<LockControllerOuterClass.UnlockServer_Responses> responseObserver) {
        if (StringUtils.isEmpty((CharSequence)this.lockIdentifier)) {
            this.respondWithError(responseObserver, SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/LockController/v1/DefinedExecutionError/ServerNotLocked", (String)"server not locked"));
            return;
        }
        if (!request.hasLockIdentifier()) {
            this.respondWithError(responseObserver, SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/LockController/v1/DefinedExecutionError/InvalidLockIdentifier", (String)"lockIdentifier required"));
            return;
        }
        if (!StringUtils.equals((CharSequence)request.getLockIdentifier().getValue(), (CharSequence)this.lockIdentifier)) {
            this.respondWithError(responseObserver, SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/LockController/v1/DefinedExecutionError/InvalidLockIdentifier", (String)"invalid lockIdentifier"));
            return;
        }
        this.handleUnlockServer();
        responseObserver.onNext((Object)LockControllerOuterClass.UnlockServer_Responses.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Override
    public void subscribeIsLocked(LockControllerOuterClass.Subscribe_IsLocked_Parameters request, StreamObserver<LockControllerOuterClass.Subscribe_IsLocked_Responses> responseObserver) {
        responseObserver.onNext((Object)LockControllerOuterClass.Subscribe_IsLocked_Responses.newBuilder().setIsLocked(SiLABoolean.from((boolean)StringUtils.isNotEmpty((CharSequence)this.lockIdentifier))).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getFCPAffectedByMetadataLockIdentifier(LockControllerOuterClass.Get_FCPAffectedByMetadata_LockIdentifier_Parameters request, StreamObserver<LockControllerOuterClass.Get_FCPAffectedByMetadata_LockIdentifier_Responses> responseObserver) {
        LockControllerOuterClass.Get_FCPAffectedByMetadata_LockIdentifier_Responses fcpaResponse = LockControllerOuterClass.Get_FCPAffectedByMetadata_LockIdentifier_Responses.newBuilder().addAffectedCalls(SiLAString.from((String)"org.silastandard/core/LockController/v1/Command/LockServer")).addAffectedCalls(SiLAString.from((String)"org.silastandard/core/LockController/v1/Command/UnlockServer")).build();
        responseObserver.onNext((Object)fcpaResponse);
        responseObserver.onCompleted();
    }

    @Override
    public void close() {
        this.handleUnlockServer();
    }

    @Override
    public String getFeatureDescription() {
        return FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/LockController.sila.xml"));
    }

    @Override
    public BindableService getService() {
        return this;
    }

    private void handleLockServer(String identifier) {
        this.handleLockServer(identifier, 0L);
    }

    private void handleLockServer(String identifier, long timeout) {
        this.lockIdentifier = identifier;
        if (timeout > 0L) {
            this.lockTimer.schedule((TimerTask)new ResetLockTask(), timeout * 1000L);
        }
    }

    private void handleUnlockServer() {
        this.lockIdentifier = null;
        this.lockTimer.cancel();
    }

    private void respondWithError(StreamObserver<?> streamObserver, StatusRuntimeException exception) {
        streamObserver.onError((Throwable)exception);
        streamObserver.onCompleted();
    }

    class ResetLockTask
    extends TimerTask {
        ResetLockTask() {
        }

        @Override
        public void run() {
            log.info("lockTimer#run");
            LockController.this.lockIdentifier = null;
        }

        @Override
        public boolean cancel() {
            LockController.this.lockIdentifier = null;
            log.info("lockTimer#cancel");
            return super.cancel();
        }
    }
}

