/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.command.observable;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.RunnableCommandTask;

public class ObservableCommandWrapper<ParamType, ResultType>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandWrapper.class);
    private final UUID executionId = UUID.randomUUID();
    private final ParamType parameter;
    private final Set<StreamObserver> stateObservers = ConcurrentHashMap.newKeySet();
    private final Set<StreamObserver> intermediateResponseObservers = ConcurrentHashMap.newKeySet();
    private final ExecutionInfo executionInfo = new ExecutionInfo();
    private final Duration lifeTimeOfExecution;
    private final RunnableCommandTask<ParamType, ResultType> task;
    private final Future<ResultType> future;
    @Nullable
    private Instant expireAt = null;

    ObservableCommandWrapper(@NonNull ParamType parameter, @NonNull RunnableCommandTask<ParamType, ResultType> task, @NonNull ObservableCommandTaskRunner runner) {
        this(parameter, task, runner, null);
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (runner == null) {
            throw new NullPointerException("runner is marked non-null but is null");
        }
    }

    ObservableCommandWrapper(@NonNull ParamType param, @NonNull RunnableCommandTask<ParamType, ResultType> task, @NonNull ObservableCommandTaskRunner runner, @Nullable Duration lifeTimeOfExecution) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (runner == null) {
            throw new NullPointerException("runner is marked non-null but is null");
        }
        this.parameter = param;
        this.task = task;
        this.lifeTimeOfExecution = lifeTimeOfExecution;
        this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.waiting);
        this.future = runner.enqueueTask(() -> {
            this.task.preRun(param, this.executionId);
            return this.call();
        });
    }

    public SiLAFramework.CommandConfirmation getCommandConfirmation() {
        SiLAFramework.CommandConfirmation.Builder builder = SiLAFramework.CommandConfirmation.newBuilder().setCommandExecutionUUID(SiLAFramework.CommandExecutionUUID.newBuilder().setValue(this.executionId.toString()).build());
        if (this.lifeTimeOfExecution != null) {
            builder.setLifetimeOfExecution(SiLAFramework.Duration.newBuilder().setSeconds(this.lifeTimeOfExecution.getSeconds()).setNanos(this.lifeTimeOfExecution.getNano()).build());
        }
        return builder.build();
    }

    public ResultType call() throws StatusRuntimeException {
        this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.running);
        if (this.lifeTimeOfExecution != null) {
            this.expireAt = Instant.now().plus(this.lifeTimeOfExecution);
        }
        try {
            return this.finishCommand(this.task.run(this), null);
        }
        catch (StatusRuntimeException e) {
            this.finishCommand(null, e);
        }
        catch (Throwable e) {
            this.finishCommand(null, SiLAErrors.generateGenericExecutionError((Throwable)e));
        }
        return this.finishCommand(null, SiLAErrors.generateUndefinedExecutionError((String)"No result was returned after end of command execution"));
    }

    public ResultType finishCommand(@Nullable ResultType result, @Nullable StatusRuntimeException e) throws StatusRuntimeException {
        if (e != null) {
            log.warn("Error occurred during observable command " + this.executionId + " task execution", (Throwable)e);
            this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
            ObservableCommandWrapper.closeObservers(this.stateObservers);
            ObservableCommandWrapper.closeObservers(this.intermediateResponseObservers);
            this.task.onFinish(this, true);
            throw e;
        }
        this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully);
        ObservableCommandWrapper.closeObservers(this.stateObservers);
        ObservableCommandWrapper.closeObservers(this.intermediateResponseObservers);
        this.task.onFinish(this, false);
        return result;
    }

    public void addStateObserver(@NonNull StreamObserver<SiLAFramework.ExecutionInfo> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        streamObserver.onNext((Object)this.getSiLAExecutionInfo());
        if (this.isDone()) {
            streamObserver.onNext((Object)this.getSiLAExecutionInfo());
            streamObserver.onCompleted();
            return;
        }
        this.stateObservers.add(streamObserver);
    }

    public <IntermediateResultType> void addIntermediateResponseObserver(@NonNull StreamObserver<IntermediateResultType> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        if (this.isDone()) {
            streamObserver.onCompleted();
            return;
        }
        this.intermediateResponseObservers.add(streamObserver);
    }

    public void sendResult(@NonNull StreamObserver<ResultType> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        if (this.future.isDone()) {
            try {
                streamObserver.onNext(this.future.get());
            }
            catch (StatusRuntimeException | InterruptedException | ExecutionException e) {
                streamObserver.onError(e);
            }
        } else {
            streamObserver.onError((Throwable)SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.COMMAND_EXECUTION_NOT_FINISHED, (String)"Command Execution is not finished. The result is not yet available."));
        }
        streamObserver.onCompleted();
    }

    public <IntermediateResultType> void notifyIntermediateResponse(@NonNull IntermediateResultType intermediateResponse) {
        if (intermediateResponse == null) {
            throw new NullPointerException("intermediateResponse is marked non-null but is null");
        }
        ObservableCommandWrapper.notifyIntermediateObservers(this.intermediateResponseObservers, intermediateResponse);
    }

    private static <IntermediateResultType> void notifyIntermediateObservers(@NonNull Set<StreamObserver> intermediateResponseObservers, @NonNull IntermediateResultType intermediateResponse) {
        if (intermediateResponseObservers == null) {
            throw new NullPointerException("intermediateResponseObservers is marked non-null but is null");
        }
        if (intermediateResponse == null) {
            throw new NullPointerException("intermediateResponse is marked non-null but is null");
        }
        Iterator<StreamObserver> it = intermediateResponseObservers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onNext(intermediateResponse);
            }
            catch (Exception e) {
                element.onError((Throwable)e);
                it.remove();
            }
        }
    }

    @Override
    public void close() {
        this.future.cancel(true);
        this.task.close();
        if (!this.isDone()) {
            this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
        }
        ObservableCommandWrapper.closeObservers(this.stateObservers);
        this.stateObservers.clear();
        ObservableCommandWrapper.closeObservers(this.intermediateResponseObservers);
        this.intermediateResponseObservers.clear();
        this.expireAt = Instant.now();
    }

    public boolean isDone() {
        return this.executionInfo.state == SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError || this.executionInfo.state == SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully;
    }

    public boolean isExpired() {
        return this.expireAt != null && this.expireAt.isBefore(Instant.now());
    }

    public void setExecutionInfoAndNotify(double progressionPercent, @Nullable Duration estimatedRemainingTime) {
        this.executionInfo.progressionPercent = progressionPercent;
        this.executionInfo.estimatedRemainingTime = estimatedRemainingTime;
        this.notifyState();
    }

    private void setStateAndNotify(@NonNull SiLAFramework.ExecutionInfo.CommandStatus state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.executionInfo.state = state;
        this.notifyState();
    }

    private void notifyState() {
        ObservableCommandWrapper.notifyObservers(this.stateObservers, this.getSiLAExecutionInfo());
    }

    private static <NotifyType> void notifyObservers(@NonNull Set<StreamObserver> observers, @NonNull NotifyType valueToNotify) {
        if (observers == null) {
            throw new NullPointerException("observers is marked non-null but is null");
        }
        if (valueToNotify == null) {
            throw new NullPointerException("valueToNotify is marked non-null but is null");
        }
        Iterator<StreamObserver> it = observers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onNext(valueToNotify);
            }
            catch (Exception e) {
                log.debug("Error occurred while notifying observer");
                element.onError((Throwable)e);
                it.remove();
            }
        }
    }

    private static <NotifyType> void closeObservers(@NonNull Set<StreamObserver> observers) {
        if (observers == null) {
            throw new NullPointerException("observers is marked non-null but is null");
        }
        Iterator<StreamObserver> it = observers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onCompleted();
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    private SiLAFramework.ExecutionInfo getSiLAExecutionInfo() {
        Duration remainingTime = this.executionInfo.estimatedRemainingTime;
        SiLAFramework.ExecutionInfo.Builder builder = SiLAFramework.ExecutionInfo.newBuilder().setCommandStatus(this.executionInfo.state).setProgressInfo(SiLAReal.from((double)this.executionInfo.progressionPercent));
        if (this.lifeTimeOfExecution != null) {
            Duration lifetimeLeft;
            Duration duration = lifetimeLeft = this.expireAt == null ? this.lifeTimeOfExecution : Duration.between(Instant.now(), this.expireAt);
            if (lifetimeLeft.isNegative()) {
                builder.setUpdatedLifetimeOfExecution(SiLAFramework.Duration.newBuilder().setSeconds(0L).setNanos(0).build());
            } else {
                builder.setUpdatedLifetimeOfExecution(SiLAFramework.Duration.newBuilder().setSeconds(lifetimeLeft.getSeconds()).setNanos(lifetimeLeft.getNano()).build());
            }
        }
        if (remainingTime != null) {
            builder.setEstimatedRemainingTime(SiLAFramework.Duration.newBuilder().setSeconds(remainingTime.getSeconds()).setNanos(remainingTime.getNano()).build());
        }
        return builder.build();
    }

    public UUID getExecutionId() {
        return this.executionId;
    }

    public ParamType getParameter() {
        return this.parameter;
    }

    public Set<StreamObserver> getStateObservers() {
        return this.stateObservers;
    }

    public Set<StreamObserver> getIntermediateResponseObservers() {
        return this.intermediateResponseObservers;
    }

    ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public Duration getLifeTimeOfExecution() {
        return this.lifeTimeOfExecution;
    }

    RunnableCommandTask<ParamType, ResultType> getTask() {
        return this.task;
    }

    Future<ResultType> getFuture() {
        return this.future;
    }

    @Nullable
    public Instant getExpireAt() {
        return this.expireAt;
    }

    static final class ExecutionInfo {
        private SiLAFramework.ExecutionInfo.CommandStatus state = SiLAFramework.ExecutionInfo.CommandStatus.waiting;
        private double progressionPercent = 0.0;
        private Duration estimatedRemainingTime = null;

        ExecutionInfo() {
        }

        SiLAFramework.ExecutionInfo.CommandStatus getState() {
            return this.state;
        }
    }
}

