/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.utils;

import java.util.ArrayList;
import javax.annotation.Nullable;
import lombok.NonNull;
import sila_java.library.server_base.utils.ArgumentHelper;

public abstract class ArgumentHelperBuilder {
    public static ArgumentHelper build(int port, @NonNull String serverName, @Nullable String configPath, @Nullable String netInterface) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        return new ArgumentHelper(ArgumentHelperBuilder.toArgs(port, configPath, netInterface), serverName);
    }

    public static String[] toArgs(int port, @Nullable String configPath, @Nullable String netInterface) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-p");
        args.add(Integer.toString(port));
        if (netInterface != null && !netInterface.isEmpty()) {
            args.add("-n");
            args.add(netInterface);
        }
        if (configPath != null) {
            args.add("-c");
            args.add(configPath);
        }
        return args.toArray(new String[0]);
    }

    private ArgumentHelperBuilder() {
    }
}

