/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.upload;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.models.BasicType;
import sila_java.library.core.models.DataTypeType;
import sila_java.library.core.models.Feature;
import sila_java.library.core.models.SiLAElement;
import sila_java.library.core.sila.binary_transfer.BinaryInfo;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.mapping.feature.FeatureGenerator;
import sila_java.library.core.sila.mapping.feature.MalformedSiLAFeature;
import sila_java.library.core.sila.types.SiLABinaryTransferUUID;
import sila_java.library.core.sila.types.SiLADuration;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;
import sila_java.library.server_base.binary_transfer.upload.UploadCompletion;
import sila_java.library.server_base.binary_transfer.upload.UploadManager;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;
import sila_java.library.server_base.standard_features.v1.AuthorizationController;

public class UploadService
extends BinaryUploadGrpc.BinaryUploadImplBase {
    private static final Logger log = LoggerFactory.getLogger(UploadService.class);
    static final int MAX_CHUNK_SIZE = 0x200000;
    private static final Duration MAX_UPLOAD_DURATION = Duration.ofMinutes(10L);
    private final UploadManager uploadManager = new UploadManager();
    private final BinaryDatabase binaryDatabase;
    private final AuthorizationController.Authorize authorize;
    private final Map<String, Feature> features;
    private final Multimap<String, String> affectedByMetadata;

    public UploadService(@NonNull BinaryDatabase binaryDatabase, @NonNull Collection<String> featuresDefinitions, @NonNull AuthorizationController.Authorize authorize) {
        this(binaryDatabase, featuresDefinitions, (Multimap<String, String>)ArrayListMultimap.create(), authorize);
        if (binaryDatabase == null) {
            throw new NullPointerException("binaryDatabase is marked non-null but is null");
        }
        if (featuresDefinitions == null) {
            throw new NullPointerException("featuresDefinitions is marked non-null but is null");
        }
        if (authorize == null) {
            throw new NullPointerException("authorize is marked non-null but is null");
        }
    }

    public UploadService(@NonNull BinaryDatabase binaryDatabase, @NonNull Collection<String> featuresDefinitions, @NonNull Multimap<String, String> affectedByMetadata, @NonNull AuthorizationController.Authorize authorize) {
        if (binaryDatabase == null) {
            throw new NullPointerException("binaryDatabase is marked non-null but is null");
        }
        if (featuresDefinitions == null) {
            throw new NullPointerException("featuresDefinitions is marked non-null but is null");
        }
        if (affectedByMetadata == null) {
            throw new NullPointerException("affectedByMetadata is marked non-null but is null");
        }
        if (authorize == null) {
            throw new NullPointerException("authorize is marked non-null but is null");
        }
        this.binaryDatabase = binaryDatabase;
        this.affectedByMetadata = affectedByMetadata;
        this.features = featuresDefinitions.stream().map(f -> {
            try {
                return FeatureGenerator.generateFeature((String)f);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toMap(f -> {
            try {
                return FeatureGenerator.generateFullyQualifiedIdentifier((Feature)f);
            }
            catch (MalformedSiLAFeature e) {
                throw new RuntimeException(e);
            }
        }, f -> f));
        this.authorize = authorize;
    }

    public void createBinary(SiLABinaryTransfer.CreateBinaryRequest request, StreamObserver<SiLABinaryTransfer.CreateBinaryResponse> responseObserver) {
        try {
            String fqiCommand;
            this.authorize.authorize(request.getParameterIdentifier());
            UUID blobId = UUID.randomUUID();
            Duration expiration = MAX_UPLOAD_DURATION;
            Matcher parameterMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedCommandParameterIdentifierPattern.matcher(request.getParameterIdentifier());
            if (!parameterMatcher.matches()) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier.");
            }
            String[] featureMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedFeatureIdentifierPattern.split(request.getParameterIdentifier());
            if (featureMatcher.length < 2) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier.");
            }
            String fqiFeature = request.getParameterIdentifier().substring(0, request.getParameterIdentifier().length() - featureMatcher[1].length());
            Feature feature = this.features.get(fqiFeature);
            if (feature == null) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier.");
            }
            String[] split = featureMatcher[1].split("/");
            String commandId = split[2];
            String parameterId = split[4];
            Feature.Command command = feature.getCommand().stream().filter(c -> c.getIdentifier().equals(commandId)).findAny().orElseThrow(() -> BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier."));
            SiLAElement parameter = command.getParameter().stream().filter(c -> c.getIdentifier().equals(parameterId)).findAny().orElseThrow(() -> BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier."));
            if (!UploadService.typeContainsBinary(feature, parameter.getDataType())) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier.");
            }
            try {
                fqiCommand = FeatureGenerator.generateFullyQualifiedIdentifier((Feature)feature, (Feature.Command)command);
            }
            catch (MalformedSiLAFeature e) {
                throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Invalid parameter identifier.");
            }
            Set requiredMetadata = Stream.concat(this.affectedByMetadata.get((Object)fqiFeature).stream(), this.affectedByMetadata.get((Object)fqiCommand).stream()).collect(Collectors.toSet());
            ServerMetadataContainer serverMetadataContainer = (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get();
            for (String metadata : requiredMetadata) {
                if (serverMetadataContainer != null && serverMetadataContainer.hasFQIMetadata(metadata)) continue;
                throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_METADATA, (String)"Missing required metadata.");
            }
            this.uploadManager.addUpload(blobId, request.getBinarySize(), request.getChunkCount(), request.getParameterIdentifier(), expiration);
            responseObserver.onNext((Object)SiLABinaryTransfer.CreateBinaryResponse.newBuilder().setLifetimeOfBinary(SiLADuration.from((Duration)expiration)).setBinaryTransferUUID(blobId.toString()).build());
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
            return;
        }
        responseObserver.onCompleted();
    }

    public StreamObserver<SiLABinaryTransfer.UploadChunkRequest> uploadChunk(final StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver) {
        return new StreamObserver<SiLABinaryTransfer.UploadChunkRequest>(){

            public void onNext(SiLABinaryTransfer.UploadChunkRequest request) {
                UploadService.this.uploadChunk(request, (StreamObserver<SiLABinaryTransfer.UploadChunkResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                log.warn("Upload chunk stream exception: {}", (Object)t.getMessage(), (Object)t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private void uploadChunk(SiLABinaryTransfer.UploadChunkRequest request, StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver) {
        try {
            Duration expiration;
            block17: {
                expiration = MAX_UPLOAD_DURATION;
                UUID blobId = SiLABinaryTransferUUID.from((String)request.getBinaryTransferUUID());
                if (request.getPayload().toByteArray().length > 0x200000) {
                    throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)"Chunk size is too large.");
                }
                this.throwIfBinaryUploadNotExist(blobId);
                try {
                    UploadCompletion uploadCompletion = this.uploadManager.updateUpload(blobId, request.getChunkIndex(), request.getPayload().toByteArray(), expiration);
                    if (!uploadCompletion.isComplete()) break block17;
                    log.info("Upload {} from client complete", (Object)blobId);
                    this.uploadManager.removeUpload(blobId);
                    try (InputStream chunkStream = uploadCompletion.chunksToStream();){
                        expiration = this.binaryDatabase.addBinary(blobId, chunkStream, uploadCompletion.getParameterIdentifier());
                    }
                    uploadCompletion.close();
                    this.uploadChunkResponse(request, responseObserver, expiration);
                    responseObserver.onCompleted();
                    return;
                }
                catch (Exception e) {
                    log.warn("The following error occurred when attempting to save received chunk: {}", (Object)e.getMessage(), (Object)e);
                    throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)e.getMessage());
                }
            }
            this.uploadChunkResponse(request, responseObserver, expiration);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    private void uploadChunkResponse(SiLABinaryTransfer.UploadChunkRequest request, StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver, Duration newExpiration) {
        responseObserver.onNext((Object)SiLABinaryTransfer.UploadChunkResponse.newBuilder().setBinaryTransferUUID(request.getBinaryTransferUUID()).setChunkIndex(request.getChunkIndex()).setLifetimeOfBinary(SiLADuration.from((Duration)newExpiration)).build());
    }

    public void deleteBinary(SiLABinaryTransfer.DeleteBinaryRequest request, StreamObserver<SiLABinaryTransfer.DeleteBinaryResponse> responseObserver) {
        boolean partialUploadExists;
        boolean fullUploadExists;
        UUID binaryToDelete = SiLABinaryTransferUUID.from((String)request.getBinaryTransferUUID());
        BinaryInfo binaryInfo = null;
        try {
            binaryInfo = this.binaryDatabase.getBinaryInfo(binaryToDelete);
            fullUploadExists = true;
        }
        catch (BinaryDatabaseException ex) {
            fullUploadExists = false;
        }
        if (binaryInfo != null) {
            try {
                this.authorize.authorize(binaryInfo.getParameterIdentifier());
            }
            catch (StatusRuntimeException e) {
                responseObserver.onError((Throwable)e);
                return;
            }
        }
        boolean bl = partialUploadExists = this.uploadManager.getUpload(binaryToDelete) != null;
        if (!fullUploadExists && !partialUploadExists) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)String.format("No binary found with UUID %s", binaryToDelete)));
            return;
        }
        if (fullUploadExists) {
            try {
                this.binaryDatabase.removeBinary(binaryToDelete);
            }
            catch (BinaryDatabaseException ex) {
                responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)String.format("Failed to delete binary with UUID %s", binaryToDelete)));
                return;
            }
        }
        if (partialUploadExists && this.uploadManager.removeUpload(binaryToDelete) == null) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)String.format("Failed to delete binary with UUID %s", binaryToDelete)));
            return;
        }
        responseObserver.onNext((Object)SiLABinaryTransfer.DeleteBinaryResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    private void throwIfBinaryUploadNotExist(@Nullable UUID binaryTransferUUID) throws StatusRuntimeException {
        if (binaryTransferUUID == null || !this.uploadManager.hasUpload(binaryTransferUUID)) {
            throw BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)"Invalid Binary Transfer UUID.");
        }
    }

    private static boolean typeContainsBinary(@NonNull Feature feature, @NonNull DataTypeType dataType) {
        if (feature == null) {
            throw new NullPointerException("feature is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (dataType.getBasic() != null) {
            return dataType.getBasic().name().equals(BasicType.BINARY.name());
        }
        if (dataType.getList() != null) {
            return UploadService.typeContainsBinary(feature, dataType.getList().getDataType());
        }
        if (dataType.getConstrained() != null) {
            return UploadService.typeContainsBinary(feature, dataType.getConstrained().getDataType());
        }
        if (dataType.getStructure() != null) {
            for (SiLAElement structureType : dataType.getStructure().getElement()) {
                if (!UploadService.typeContainsBinary(feature, structureType.getDataType())) continue;
                return true;
            }
            return false;
        }
        if (dataType.getDataTypeIdentifier() != null) {
            SiLAElement dataTypeDef = feature.getDataTypeDefinition().stream().filter(d -> d.getIdentifier().equals(dataType.getDataTypeIdentifier())).findAny().orElseThrow(() -> new RuntimeException("Data Type Identifier is not present in the feature."));
            return UploadService.typeContainsBinary(feature, dataTypeDef.getDataType());
        }
        throw new RuntimeException("DataTypeType does not contain any type.");
    }
}

