/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.config;

import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.config.ServerConfiguration;

public class NonPersistentServerConfigWrapper
implements IServerConfigWrapper {
    private static final Logger log = LoggerFactory.getLogger(NonPersistentServerConfigWrapper.class);
    private ServerConfiguration configuration;

    public NonPersistentServerConfigWrapper(@NonNull String serverType) {
        if (serverType == null) {
            throw new NullPointerException("serverType is marked non-null but is null");
        }
        this.configuration = new ServerConfiguration(serverType);
    }

    public NonPersistentServerConfigWrapper(@NonNull ServerConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
    }

    @Override
    public ServerConfiguration getCacheConfig() {
        return this.configuration;
    }

    @Override
    public void setConfig(@NonNull ServerConfiguration serverConfiguration) {
        if (serverConfiguration == null) {
            throw new NullPointerException("serverConfiguration is marked non-null but is null");
        }
        this.configuration = serverConfiguration;
    }
}

