/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.standard_features.v1;

import io.grpc.BindableService;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila_java.library.core.models.Feature;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.mapping.feature.FeatureGenerator;
import sila_java.library.core.sila.types.SiLAString;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.config.IServerConfigWrapper;
import sila_java.library.server_base.config.ServerConfiguration;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;
import sila_java.library.server_base.metadata.ServerMetadataContainer;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.sila_base.EmptyClass;

public class SiLAServiceServer
implements FeatureImplementation {
    private static final Logger log = LoggerFactory.getLogger(SiLAServiceServer.class);
    private final Map<String, String> featureDefinitions = new HashMap<String, String>();
    private final IServerConfigWrapper serverConfigurationContainer;
    private final ServerInformation serverInformation;

    public SiLAServiceServer(@NonNull IServerConfigWrapper serverConfigurationContainer, @Nonnull ServerInformation serverInformation, @Nonnull Map<String, String> featureDefinitions) {
        if (serverConfigurationContainer == null) {
            throw new NullPointerException("serverConfigurationContainer is marked non-null but is null");
        }
        this.serverConfigurationContainer = serverConfigurationContainer;
        this.serverInformation = serverInformation;
        featureDefinitions.put(FeatureGenerator.generateFullyQualifiedIdentifier((Feature)FeatureGenerator.generateFeature((String)this.getFeatureDescription())), this.getFeatureDescription());
        log.info("[SiLAService] create service for: {}\nfeatureDefinitions={} ...", (Object)serverInformation, featureDefinitions.keySet());
        for (Map.Entry<String, String> entry : featureDefinitions.entrySet()) {
            String key = entry.getKey();
            try {
                String featureDefinition = entry.getValue();
                Utils.validateFeatureXML((String)featureDefinition);
                this.featureDefinitions.put(key, featureDefinition);
                log.info("[registerServer] type={} feature={} is read from XML string.", (Object)serverInformation.getType(), (Object)key);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error registering feature definition for server = " + serverInformation.getType() + "& feature = '" + key + "' is not valid", e);
            }
        }
        log.info("[registerServer] server type = {} with features successfully registered!", (Object)serverInformation.getType());
    }

    @Override
    public String getFeatureDescription() {
        return FileUtils.getFileContent((InputStream)Objects.requireNonNull(EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SiLAService-v1_0.sila.xml")));
    }

    @Override
    public BindableService getService() {
        return new ServiceImpl();
    }

    public Map<String, String> getFeatureDefinitions() {
        return this.featureDefinitions;
    }

    public ServerInformation getServerInformation() {
        return this.serverInformation;
    }

    private class ServiceImpl
    extends SiLAServiceGrpc.SiLAServiceImplBase {
        private ServiceImpl() {
        }

        @Override
        public void getFeatureDefinition(@NonNull SiLAServiceOuterClass.GetFeatureDefinition_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.GetFeatureDefinition_Responses> responseObserver) {
            boolean isValidFeatureId;
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            if (!req.hasFeatureIdentifier()) {
                responseObserver.onError((Throwable)SiLAErrors.generateValidationError((String)"org.silastandard/core/SiLAService/v1/Command/GetFeatureDefinition/Parameter/FeatureIdentifier", (String)"Missing feature identifier."));
            }
            if (!(isValidFeatureId = FullyQualifiedIdentifierUtils.FullyQualifiedFeatureIdentifierPattern.matcher(req.getFeatureIdentifier().getValue()).matches())) {
                responseObserver.onError((Throwable)SiLAErrors.generateValidationError((String)"org.silastandard/core/SiLAService/v1/Command/GetFeatureDefinition/Parameter/FeatureIdentifier", (String)"Invalid feature identifier."));
            }
            String featureIdentifier = req.getFeatureIdentifier().getValue();
            String serverName = SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getName();
            log.debug("[{}][getFeatureDefinition] feature={} entered.", (Object)serverName, (Object)featureIdentifier);
            String featureDefinitionContent = (String)SiLAServiceServer.this.featureDefinitions.get(featureIdentifier);
            if (featureDefinitionContent == null) {
                responseObserver.onError((Throwable)SiLAErrors.generateDefinedExecutionError((String)"org.silastandard/core/SiLAService/v1/DefinedExecutionError/UnimplementedFeature", (String)String.format("The server does not implement the feature '%s'", featureIdentifier)));
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.GetFeatureDefinition_Responses.newBuilder().setFeatureDefinition(SiLAString.from((String)featureDefinitionContent)).build());
            responseObserver.onCompleted();
            log.debug("[{}][getFeatureDefinition] feature={} returned={}.", new Object[]{serverName, featureIdentifier, featureDefinitionContent});
        }

        @Override
        public void setServerName(SiLAServiceOuterClass.SetServerName_Parameters req, StreamObserver<SiLAServiceOuterClass.SetServerName_Responses> responseObserver) {
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            String serverName = req.getServerName().getValue();
            if (serverName.length() > 255) {
                responseObserver.onError((Throwable)SiLAErrors.generateValidationError((String)"org.silastandard/core/SiLAService/v1/Command/SetServerName/Parameter/ServerName", (String)"Server name must not be longer than 255 characters"));
                return;
            }
            if (serverName.isEmpty()) {
                responseObserver.onError((Throwable)SiLAErrors.generateValidationError((String)"org.silastandard/core/SiLAService/v1/Command/SetServerName/Parameter/ServerName", (String)"Server name must not be empty"));
                return;
            }
            log.info("setServerName being called, Server Name: {}", (Object)serverName);
            try {
                SiLAServiceServer.this.serverConfigurationContainer.setConfig(new ServerConfiguration(serverName, SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getUuid()));
                responseObserver.onNext((Object)SiLAServiceOuterClass.SetServerName_Responses.newBuilder().build());
                responseObserver.onCompleted();
            }
            catch (IOException e) {
                StatusRuntimeException error = SiLAErrors.generateGenericExecutionError((Throwable)e);
                responseObserver.onError((Throwable)error);
            }
        }

        @Override
        public void getServerName(SiLAServiceOuterClass.Get_ServerName_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerName_Responses> responseObserver) {
            log.debug("getServerName being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerName_Responses.newBuilder().setServerName(SiLAString.from((String)SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getName())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerType(SiLAServiceOuterClass.Get_ServerType_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerType_Responses> responseObserver) {
            log.debug("getServerType being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerType_Responses.newBuilder().setServerType(SiLAString.from((String)SiLAServiceServer.this.serverInformation.getType())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerUUID(SiLAServiceOuterClass.Get_ServerUUID_Parameters req, StreamObserver<SiLAServiceOuterClass.Get_ServerUUID_Responses> responseObserver) {
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerUUID_Responses.newBuilder().setServerUUID(SiLAString.from((String)SiLAServiceServer.this.serverConfigurationContainer.getCacheConfig().getUuid().toString())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerDescription(@NonNull SiLAServiceOuterClass.Get_ServerDescription_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerDescription_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            log.debug("getServerDescription being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerDescription_Responses.newBuilder().setServerDescription(SiLAString.from((String)SiLAServiceServer.this.serverInformation.getDescription())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerVersion(@NonNull SiLAServiceOuterClass.Get_ServerVersion_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerVersion_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            log.debug("getServerVersion being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerVersion_Responses.newBuilder().setServerVersion(SiLAString.from((String)SiLAServiceServer.this.serverInformation.getVersion())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getServerVendorURL(@NonNull SiLAServiceOuterClass.Get_ServerVendorURL_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ServerVendorURL_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            log.debug("getServerVendorName being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            responseObserver.onNext((Object)SiLAServiceOuterClass.Get_ServerVendorURL_Responses.newBuilder().setServerVendorURL(SiLAString.from((String)SiLAServiceServer.this.serverInformation.getVendorURL())).build());
            responseObserver.onCompleted();
        }

        @Override
        public void getImplementedFeatures(@NonNull SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters req, @NonNull StreamObserver<SiLAServiceOuterClass.Get_ImplementedFeatures_Responses> responseObserver) {
            if (req == null) {
                throw new NullPointerException("req is marked non-null but is null");
            }
            if (responseObserver == null) {
                throw new NullPointerException("responseObserver is marked non-null but is null");
            }
            log.debug("getImplementedFeatures being called");
            if (this.rejectMetadata(responseObserver)) {
                return;
            }
            SiLAServiceOuterClass.Get_ImplementedFeatures_Responses.Builder idBuilder = SiLAServiceOuterClass.Get_ImplementedFeatures_Responses.newBuilder();
            SiLAServiceServer.this.featureDefinitions.keySet().forEach(featureId -> idBuilder.addImplementedFeatures(SiLAString.from((String)featureId)));
            responseObserver.onNext((Object)idBuilder.build());
            responseObserver.onCompleted();
        }

        private boolean rejectMetadata(StreamObserver<?> responseObserver) {
            ServerMetadataContainer serverMetadataContainer = (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get();
            if (serverMetadataContainer != null && !serverMetadataContainer.isEmpty()) {
                responseObserver.onError((Throwable)SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.NO_METADATA_ALLOWED, (String)"No metadata must be provided to the SiLA Service."));
                return true;
            }
            return false;
        }
    }
}

