/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.config;

import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import lombok.NonNull;

@Immutable
public final class ServerConfiguration {
    private final String name;
    private final UUID uuid;

    public static ServerConfiguration generateDefault(@NonNull String serverType) {
        if (serverType == null) {
            throw new NullPointerException("serverType is marked non-null but is null");
        }
        return new ServerConfiguration(serverType, UUID.randomUUID());
    }

    public ServerConfiguration withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new ServerConfiguration(name, this.uuid);
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ServerConfiguration(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
    }
}

