/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import lombok.NonNull;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.communication.utils.ListNetworkInterfaces;
import sila_java.library.core.utils.GitRepositoryState;

public class ArgumentHelper {
    private static final Logger log = LoggerFactory.getLogger(ArgumentHelper.class);
    private final String[] args;
    private final Namespace ns;

    public ArgumentHelper(@NonNull String[] args, @NonNull String serverName) {
        this(args, serverName, null);
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
    }

    public ArgumentHelper(@NonNull String[] args, @NonNull String serverName, ArgumentParser baseParser) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        this.args = args;
        ArgumentParser parser = baseParser == null ? ArgumentParsers.newFor((String)serverName).build().defaultHelp(true).description("SiLA Server.") : baseParser;
        parser.addArgument(new String[]{"-p", "--port"}).type(Integer.class).help("Specify port to use.");
        parser.addArgument(new String[]{"-n", "--networkInterface"}).type(String.class).help("Specify network interface. Check using the ifconfig command on Linux or MacOS and ipconfig on Windows.");
        parser.addArgument(new String[]{"-H", "--host"}).type(String.class).help("Specify the host at which the SiLAClient is running.");
        parser.addArgument(new String[]{"-c", "--configFile"}).type(String.class).help("Specify the file name to use to read/store server information.");
        parser.addArgument(new String[]{"-l", "--listNetworks"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("List names of network interfaces found.");
        parser.addArgument(new String[]{"-u", "--unsafeCommunication"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("Use non-standard plain-text unsecure communication.");
        parser.addArgument(new String[]{"-s", "--simulation"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("Specify (if supported) to start the server with simulation mode enabled.");
        parser.addArgument(new String[]{"-v", "--version"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("Display server version.");
        parser.addArgument(new String[]{"-k", "--privateKey"}).type(String.class).setDefault((Object)"./private.pem").help("Path to Private key (e.g. 'private.pem')");
        parser.addArgument(new String[]{"-cr", "--certificate"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).type(String.class).setDefault((Object)"./cert.pem").help("Path to Certificate (e.g. 'cert.pem')");
        parser.addArgument(new String[]{"-crp", "--certificatePassword"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).type(String.class).help("Password to unlock the certificate.");
        this.ns = parser.parseArgsOrFail(args);
        if (this.ns.getBoolean("listNetworks").booleanValue()) {
            ListNetworkInterfaces.display();
            System.exit(0);
        }
        if (this.ns.getBoolean("version").booleanValue()) {
            try {
                System.out.println(new GitRepositoryState().generateVersion());
                System.exit(0);
            }
            catch (IOException e) {
                log.warn("Unable to retrieve version", (Throwable)e);
                System.out.println("Unknown version");
                System.exit(0);
            }
        }
    }

    public Optional<Integer> getPort() {
        Integer port = this.ns.getInt("port");
        return port == null ? Optional.empty() : Optional.of(port);
    }

    public Optional<String> getInterface() {
        String networkInterface = this.ns.getString("networkInterface");
        return networkInterface == null ? Optional.empty() : Optional.of(networkInterface);
    }

    public Optional<Path> getConfigFile() {
        String configFile = this.ns.getString("configFile");
        return configFile == null ? Optional.empty() : Optional.of(Paths.get(configFile, new String[0]));
    }

    public Path getPrivateKeyFile() {
        String privateKey = this.ns.getString("privateKey");
        return Paths.get(privateKey, new String[0]);
    }

    public String getCertificatePassword() {
        return this.ns.getString("certificatePassword");
    }

    public Path getCertificateFile() {
        String certificate = this.ns.getString("certificate");
        return Paths.get(certificate, new String[0]);
    }

    public Optional<String> getHost() {
        String host = this.ns.getString("host");
        return host == null ? Optional.empty() : Optional.of(host);
    }

    public boolean isSimulationEnabled() {
        return this.ns.getBoolean("simulation");
    }

    public boolean useUnsafeCommunication() {
        return this.ns.getBoolean("unsafeCommunication");
    }

    public String[] getArgs() {
        return this.args;
    }

    public Namespace getNs() {
        return this.ns;
    }
}

