/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.utils;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.internal.SerializingExecutor;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import sila_java.library.core.sila.errors.SiLAErrors;

public final class TransmitThrowableInterceptor
implements ServerInterceptor {
    public static ServerInterceptor instance() {
        return new TransmitThrowableInterceptor();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        SerializingServerCall<ReqT, RespT> serverCall = new SerializingServerCall<ReqT, RespT>(call);
        ServerCall.Listener listener = next.startCall(serverCall, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener, (ServerCall)serverCall){
            final /* synthetic */ ServerCall val$serverCall;
            {
                this.val$serverCall = serverCall;
                super(x0);
            }

            public void onMessage(ReqT message) {
                try {
                    super.onMessage(message);
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onHalfClose() {
                try {
                    super.onHalfClose();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onCancel() {
                try {
                    super.onCancel();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onComplete() {
                try {
                    super.onComplete();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onReady() {
                try {
                    super.onReady();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            private void closeWithException(Throwable t) {
                Metadata metadata;
                if (!(t instanceof StatusRuntimeException)) {
                    t = SiLAErrors.generateGenericExecutionError((Throwable)t);
                }
                if ((metadata = ((StatusRuntimeException)t).getTrailers()) == null) {
                    metadata = new Metadata();
                }
                this.val$serverCall.close(((StatusRuntimeException)t).getStatus(), metadata);
            }
        };
    }

    private TransmitThrowableInterceptor() {
    }

    private static class SerializingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private final SerializingExecutor serializingExecutor = new SerializingExecutor(MoreExecutors.directExecutor());
        private boolean closeCalled = false;

        SerializingServerCall(ServerCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void sendMessage(RespT message) {
            this.serializingExecutor.execute(() -> SerializingServerCall.super.sendMessage(message));
        }

        public void request(int numMessages) {
            this.serializingExecutor.execute(() -> SerializingServerCall.super.request(numMessages));
        }

        public void sendHeaders(Metadata headers) {
            this.serializingExecutor.execute(() -> SerializingServerCall.super.sendHeaders(headers));
        }

        public void close(Status status, Metadata trailers) {
            this.serializingExecutor.execute(() -> {
                if (!this.closeCalled) {
                    this.closeCalled = true;
                    SerializingServerCall.super.close(status, trailers);
                }
            });
        }

        public boolean isReady() {
            SettableFuture future = SettableFuture.create();
            this.serializingExecutor.execute(() -> future.set((Object)SerializingServerCall.super.isReady()));
            try {
                return (Boolean)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Encountered error during serialized access", e);
            }
        }

        public boolean isCancelled() {
            SettableFuture future = SettableFuture.create();
            this.serializingExecutor.execute(() -> future.set((Object)SerializingServerCall.super.isCancelled()));
            try {
                return (Boolean)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Encountered error during serialized access", e);
            }
        }

        public void setMessageCompression(boolean enabled) {
            this.serializingExecutor.execute(() -> SerializingServerCall.super.setMessageCompression(enabled));
        }

        public void setCompression(String compressor) {
            this.serializingExecutor.execute(() -> SerializingServerCall.super.setCompression(compressor));
        }

        public Attributes getAttributes() {
            SettableFuture future = SettableFuture.create();
            this.serializingExecutor.execute(() -> future.set((Object)SerializingServerCall.super.getAttributes()));
            try {
                return (Attributes)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Encountered error during serialized access", e);
            }
        }

        @Nullable
        public String getAuthority() {
            SettableFuture future = SettableFuture.create();
            this.serializingExecutor.execute(() -> future.set((Object)SerializingServerCall.super.getAuthority()));
            try {
                return (String)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Encountered error during serialized access", e);
            }
        }
    }
}

