/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.command.observable;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.ObservableCommandWrapper;
import sila_java.library.server_base.command.observable.RunnableCommandTask;

public class ObservableCommandManager<ParamType, ResultType>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandManager.class);
    private final Map<UUID, ObservableCommandWrapper<ParamType, ResultType>> commands = new ConcurrentHashMap<UUID, ObservableCommandWrapper<ParamType, ResultType>>();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    private final RunnableCommandTask<ParamType, ResultType> task;
    private final ObservableCommandTaskRunner runner;
    private final Duration lifeTimeOfCommandExecution;

    public ObservableCommandManager(@NonNull ObservableCommandTaskRunner taskRunner, @NonNull RunnableCommandTask<ParamType, ResultType> task) {
        this(taskRunner, task, null);
        if (taskRunner == null) {
            throw new NullPointerException("taskRunner is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    public ObservableCommandManager(@NonNull ObservableCommandTaskRunner taskRunner, @NonNull RunnableCommandTask<ParamType, ResultType> task, @Nullable Duration lifeTimeOfCommandExecution) {
        if (taskRunner == null) {
            throw new NullPointerException("taskRunner is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (lifeTimeOfCommandExecution != null && (lifeTimeOfCommandExecution.isNegative() || lifeTimeOfCommandExecution.isZero())) {
            throw new IllegalArgumentException("LifeTimeOfCommandExecution duration must be greater than 0");
        }
        this.task = task;
        this.runner = taskRunner;
        this.lifeTimeOfCommandExecution = lifeTimeOfCommandExecution;
    }

    public ObservableCommandWrapper<ParamType, ResultType> addCommand(@NonNull ParamType param, @NonNull StreamObserver<SiLAFramework.CommandConfirmation> observer) throws StatusRuntimeException {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        try {
            ObservableCommandWrapper<ParamType, ResultType> command = new ObservableCommandWrapper<ParamType, ResultType>(param, this.task, this.runner, this::remove, this.scheduledExecutor, this.lifeTimeOfCommandExecution);
            this.notifyNewConcurrentCommand(command);
            this.commands.put(command.getExecutionId(), command);
            if (observer instanceof ServerCallStreamObserver) {
                ((ServerCallStreamObserver)observer).setOnCancelHandler(() -> this.remove(command.getExecutionId()));
            } else {
                log.warn("Current stream observer implementation does not allow to check reception of command UUID");
            }
            observer.onNext((Object)command.getCommandConfirmation());
            observer.onCompleted();
            return command;
        }
        catch (RejectedExecutionException e) {
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
    }

    public ObservableCommandWrapper<ParamType, ResultType> get(@NonNull SiLAFramework.CommandExecutionUUID executionId) throws StatusRuntimeException {
        UUID uuid;
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        try {
            uuid = UUID.fromString(executionId.getValue());
        }
        catch (IllegalArgumentException e) {
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
        return this.get(uuid);
    }

    public ObservableCommandWrapper<ParamType, ResultType> get(@NonNull UUID executionId) throws StatusRuntimeException {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        ObservableCommandWrapper<ParamType, ResultType> command = this.commands.get(executionId);
        if (command == null) {
            throw SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.INVALID_COMMAND_EXECUTION_UUID, (String)"The Command Execution UUID is not valid. There is no command executed with the UUID.");
        }
        return command;
    }

    @Override
    public void close() {
        this.commands.values().forEach(ObservableCommandWrapper::close);
        this.commands.clear();
        this.runner.close();
        this.scheduledExecutor.shutdownNow();
    }

    public void remove(@NonNull UUID executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        ObservableCommandWrapper<ParamType, ResultType> command = this.commands.get(executionId);
        if (command != null) {
            command.close();
            this.commands.remove(executionId);
        }
    }

    private void notifyNewConcurrentCommand(@NonNull ObservableCommandWrapper<ParamType, ResultType> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.commands.values().forEach(c -> c.getTask().onNewCommand(command));
    }
}

