/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.standard_features;

import io.grpc.BindableService;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderGrpc;
import sila2.org.silastandard.core.commands.parameterconstraintsprovider.v1.ParameterConstraintsProviderOuterClass;
import sila_java.library.core.models.Constraints;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.sila_base.EmptyClass;

public class ParameterConstraintsProvider
implements FeatureImplementation,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ParameterConstraintsProvider.class);
    private final Map<String, Constraints> constraints = new ConcurrentHashMap<String, Constraints>();
    private final List<StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses>> constraintUpdateObservers = new CopyOnWriteArrayList<StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses>>();

    @Override
    public String getFeatureDescription() {
        return FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/commands/ParameterConstraintsProvider.sila.xml"));
    }

    @Override
    public BindableService getService() {
        return new ServiceImpl();
    }

    @Override
    public synchronized void close() {
        this.constraintUpdateObservers.forEach(observer -> {
            try {
                observer.onCompleted();
            }
            catch (StatusRuntimeException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        });
        this.constraintUpdateObservers.clear();
    }

    public Map<String, Constraints> getParametersConstraints() {
        return Collections.unmodifiableMap(this.constraints);
    }

    public void putConstraint(@NonNull String parameterId, @NonNull Constraints constraints) {
        if (parameterId == null) {
            throw new NullPointerException("parameterId is marked non-null but is null");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints is marked non-null but is null");
        }
        if (this.constraints.containsKey(parameterId)) {
            log.debug("Parameter {} already had a constraint, overwriting it", (Object)parameterId);
        }
        this.constraints.put(parameterId, constraints);
        this.notifyObservers();
    }

    public void removeConstraint(@NonNull String parameterId) {
        if (parameterId == null) {
            throw new NullPointerException("parameterId is marked non-null but is null");
        }
        this.constraints.remove(parameterId);
        this.notifyObservers();
    }

    private boolean notifyObserver(@NonNull StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses> observer, @NonNull ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses response) {
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        try {
            observer.onNext((Object)response);
        }
        catch (Throwable e) {
            observer.onError(e);
            log.debug("Lost connection with constraints property observer", e);
            return true;
        }
        return false;
    }

    private void notifyObservers() {
        ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses response;
        try {
            response = this.getConstraintsResponse();
        }
        catch (JAXBException e) {
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
        this.constraintUpdateObservers.removeIf(next -> this.notifyObserver((StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses>)next, response));
    }

    private ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses getConstraintsResponse() throws JAXBException {
        ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses.Builder builder = ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses.newBuilder();
        for (Map.Entry<String, Constraints> entry : this.constraints.entrySet()) {
            builder.addParametersConstraints(ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses.ParametersConstraints_Struct.newBuilder().setCommandParameterIdentifier(SiLAFramework.String.newBuilder().setValue(entry.getKey()).build()).setConstraints(SiLAFramework.String.newBuilder().setValue(ParameterConstraintsProvider.constraintToXml(entry.getValue())).build()).build());
        }
        return builder.build();
    }

    private static String constraintToXml(@NonNull Constraints constraints) throws JAXBException {
        if (constraints == null) {
            throw new NullPointerException("constraints is marked non-null but is null");
        }
        Marshaller jaxbMarshaller = JAXBContext.newInstance((Class[])new Class[]{Constraints.class}).createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        QName qName = new QName("", Constraints.class.getSimpleName());
        JAXBElement root = new JAXBElement(qName, Constraints.class, (Object)constraints);
        jaxbMarshaller.marshal((Object)root, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private class ServiceImpl
    extends ParameterConstraintsProviderGrpc.ParameterConstraintsProviderImplBase {
        private ServiceImpl() {
        }

        @Override
        public void subscribeParametersConstraints(ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Parameters request, StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses> responseObserver) {
            try {
                if (ParameterConstraintsProvider.this.notifyObserver((StreamObserver<ParameterConstraintsProviderOuterClass.Subscribe_ParametersConstraints_Responses>)responseObserver, ParameterConstraintsProvider.this.getConstraintsResponse())) {
                    return;
                }
            }
            catch (JAXBException e) {
                throw SiLAErrors.generateGenericExecutionError((Throwable)e);
            }
            ParameterConstraintsProvider.this.constraintUpdateObservers.add(responseObserver);
        }
    }
}

