/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import sila_java.library.server_base.utils.ArgumentHelperBuilder;

public abstract class ServerProcessBuilder {
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static Process build(final @NonNull String serverJarPath, final int port, final @NonNull Path configPath, final @Nullable String netInterface) throws IOException {
        if (serverJarPath == null) {
            throw new NullPointerException("serverJarPath is marked non-null but is null");
        }
        if (configPath == null) {
            throw new NullPointerException("configPath is marked non-null but is null");
        }
        ArrayList<String> args = new ArrayList<String>(){
            {
                this.add("java");
                this.add("-jar");
                this.add(serverJarPath);
                Collections.addAll(this, ArgumentHelperBuilder.toArgs(port, configPath.toString(), netInterface));
            }
        };
        return new ProcessBuilder((List<String>)args).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(NULL_FILE).start();
    }

    private ServerProcessBuilder() {
    }
}

