/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.errors;

import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import sila2.org.silastandard.SiLABinaryTransfer;

public abstract class BinaryTransferErrorHandler {
    public static StatusRuntimeException generateBinaryTransferError(@NonNull SiLABinaryTransfer.BinaryTransferError.ErrorType errorIdentifier, @NonNull String message) {
        if (errorIdentifier == null) {
            throw new NullPointerException("errorIdentifier is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return BinaryTransferErrorHandler.generateGRPCError(SiLABinaryTransfer.BinaryTransferError.newBuilder().setErrorType(errorIdentifier).setMessage(message).build());
    }

    public static Optional<SiLABinaryTransfer.BinaryTransferError> retrieveBinaryTransferError(@Nonnull StatusRuntimeException statusRuntimeException) {
        Status status = statusRuntimeException.getStatus();
        if (!status.getCode().equals((Object)Status.Code.ABORTED)) {
            return Optional.empty();
        }
        try {
            String description = status.getDescription() == null ? "No description" : status.getDescription();
            return Optional.of(SiLABinaryTransfer.BinaryTransferError.parseFrom((byte[])DatatypeConverter.parseBase64Binary((String)description)));
        }
        catch (InvalidProtocolBufferException e) {
            return Optional.empty();
        }
    }

    private static StatusRuntimeException generateGRPCError(@Nonnull SiLABinaryTransfer.BinaryTransferError binaryTransferError) {
        return new StatusRuntimeException(Status.ABORTED.withDescription(DatatypeConverter.printBase64Binary((byte[])binaryTransferError.toByteArray())));
    }

    private BinaryTransferErrorHandler() {
    }
}

