/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.upload;

import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.server_base.binary_transfer.upload.UploadCompletion;

class UploadManager {
    private static final Logger log = LoggerFactory.getLogger(UploadManager.class);
    private final ExpiringMap<UUID, UploadCompletion> uploads = ExpiringMap.builder().variableExpiration().asyncExpirationListener(UploadManager::onEntryExpiration).build();

    UploadManager() {
    }

    UploadCompletion removeUpload(@NonNull UUID binaryId) {
        if (binaryId == null) {
            throw new NullPointerException("binaryId is marked non-null but is null");
        }
        return (UploadCompletion)this.uploads.remove((Object)binaryId);
    }

    UploadCompletion getUpload(@NonNull UUID binaryId) {
        if (binaryId == null) {
            throw new NullPointerException("binaryId is marked non-null but is null");
        }
        return (UploadCompletion)this.uploads.get((Object)binaryId);
    }

    UploadCompletion updateUpload(@NonNull UUID binaryId, int chunkIndex, @NonNull byte[] data, @NonNull Duration expiration) throws IOException {
        if (binaryId == null) {
            throw new NullPointerException("binaryId is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (expiration == null) {
            throw new NullPointerException("expiration is marked non-null but is null");
        }
        UploadCompletion upload = this.getUpload(binaryId);
        this.uploads.setExpiration(expiration.getSeconds(), TimeUnit.SECONDS);
        upload.addChunk(chunkIndex, data);
        return upload;
    }

    void addUpload(@NonNull UUID binaryId, long totalLength, int nbChunks, @NonNull Duration expiration) {
        if (binaryId == null) {
            throw new NullPointerException("binaryId is marked non-null but is null");
        }
        if (expiration == null) {
            throw new NullPointerException("expiration is marked non-null but is null");
        }
        if (this.uploads.containsKey((Object)binaryId)) {
            throw new IllegalStateException("Upload is already present in the upload manager");
        }
        this.uploads.put((Object)binaryId, (Object)new UploadCompletion(totalLength, nbChunks), ExpirationPolicy.CREATED, expiration.getSeconds(), TimeUnit.SECONDS);
    }

    private static void onEntryExpiration(UUID uploadId, UploadCompletion uploadCompletion) {
        log.info("Client upload with id {} expired", (Object)uploadId);
        uploadCompletion.close();
    }
}

