/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.command.observable;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableCommandTaskRunner
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandTaskRunner.class);
    private final ThreadPoolExecutor executorService;

    public ObservableCommandTaskRunner(int maxQueueSize, int maxConcurrentCalls) {
        if (maxQueueSize < 0) {
            throw new IllegalArgumentException("Max Queue size cannot be lower than 0");
        }
        if (maxConcurrentCalls < 1) {
            throw new IllegalArgumentException("Max Concurrent call cannot be lower than 1");
        }
        SynchronousQueue<Runnable> queueImpl = maxQueueSize == 0 ? new SynchronousQueue(true) : new ArrayBlockingQueue(maxQueueSize, true);
        this.executorService = new ThreadPoolExecutor(maxConcurrentCalls, maxConcurrentCalls, 0L, TimeUnit.MILLISECONDS, queueImpl);
    }

    <ResultType> Future<ResultType> enqueueTask(@NonNull Callable<ResultType> callable) throws RejectedExecutionException {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        return this.executorService.submit(callable);
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }
}

