/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.metadata;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import sila_java.library.core.sila.errors.SiLAErrorException;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;
import sila_java.library.server_base.metadata.ServerMetadataContainer;

public abstract class MetadataInterceptor
implements ServerInterceptor {
    private final List<Pattern> affectedCallTargetPatterns;
    private static final ServerCall.Listener emptyListener = new ServerCall.Listener(){};

    public abstract <ReqT, RespT> Context intercept(ServerCall<ReqT, RespT> var1, ServerMetadataContainer var2);

    public MetadataInterceptor(@NonNull List<String> affectedCalls) {
        if (affectedCalls == null) {
            throw new NullPointerException("affectedCalls is marked non-null but is null");
        }
        this.affectedCallTargetPatterns = MetadataInterceptor.getAffectedCallTargetPatterns(affectedCalls);
    }

    public MetadataInterceptor(@NonNull String affectedCall) {
        if (affectedCall == null) {
            throw new NullPointerException("affectedCall is marked non-null but is null");
        }
        this.affectedCallTargetPatterns = MetadataInterceptor.getAffectedCallTargetPatterns(Collections.singletonList(affectedCall));
    }

    public final <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String callTarget = call.getMethodDescriptor().getFullMethodName();
        if (this.affectedCallTargetPatterns.stream().noneMatch(pattern -> pattern.matcher(callTarget).matches())) {
            return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
        }
        ServerMetadataContainer metadata = ServerMetadataContainer.current() == null ? ServerMetadataContainer.fromHeaders(headers) : ServerMetadataContainer.current();
        try {
            Context newContext = this.intercept(call, metadata);
            return Contexts.interceptCall((Context)newContext, call, (Metadata)headers, next);
        }
        catch (Throwable e) {
            call.close(new SiLAErrorException(SiLAErrors.throwableToSiLAError((Throwable)e)).getStatus(), headers);
            return emptyListener;
        }
    }

    private static List<Pattern> getAffectedCallTargetPatterns(@NonNull List<String> affectedCalls) {
        if (affectedCalls == null) {
            throw new NullPointerException("affectedCalls is marked non-null but is null");
        }
        return affectedCalls.stream().map(MetadataInterceptor::getAffectedCallTargetPattern).collect(Collectors.toList());
    }

    private static Pattern getAffectedCallTargetPattern(String affectedCall) {
        boolean isValidFQI;
        Matcher featureIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedFeatureIdentifierPattern.matcher(affectedCall);
        Matcher commandIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedCommandIdentifierPattern.matcher(affectedCall);
        Matcher propertyIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedPropertyIdentifierPattern.matcher(affectedCall);
        boolean bl = isValidFQI = !featureIdentifierMatcher.matches() && !commandIdentifierMatcher.matches() && !propertyIdentifierMatcher.matches();
        if (isValidFQI) {
            throw new IllegalArgumentException(String.format("Given argument is no fully qualified feature, command, or property identifier: '%s'", affectedCall));
        }
        String featureIdentifier = affectedCall.split("/")[2];
        String callPrefix = String.join((CharSequence)"\\.", "sila2", affectedCall.toLowerCase().replace('/', '.'), featureIdentifier);
        callPrefix = commandIdentifierMatcher.matches() ? callPrefix + "/" + affectedCall.split("/")[5] : (propertyIdentifierMatcher.matches() ? callPrefix + "/(Get_|Subscribe_)" + affectedCall.split("/")[5] : callPrefix + "/(Get_|Subscribe_)?[A-Z][a-zA-Z0-9]*");
        return Pattern.compile(callPrefix);
    }
}

