/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.standard_features;

import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import lombok.NonNull;
import sila2.org.silastandard.core.simulationcontroller.v1.SimulationControllerGrpc;
import sila2.org.silastandard.core.simulationcontroller.v1.SimulationControllerOuterClass;
import sila_java.library.core.sila.types.SiLABoolean;
import sila_java.library.core.utils.FileUtils;
import sila_java.library.server_base.standard_features.FeatureImplementation;
import sila_java.library.sila_base.EmptyClass;

public class SimulationController
extends SimulationControllerGrpc.SimulationControllerImplBase
implements FeatureImplementation,
AutoCloseable {
    private final List<ContextSwitcher> contextSwitchers = Collections.synchronizedList(new ArrayList());
    private boolean simulation;

    public <T extends Context> ContextSwitcher<T> createContextSwitcher(@NonNull Provider<T> real, @NonNull T sim) {
        if (real == null) {
            throw new NullPointerException("real is marked non-null but is null");
        }
        if (sim == null) {
            throw new NullPointerException("sim is marked non-null but is null");
        }
        ContextSwitcher wrapper = new ContextSwitcher(this, real, sim);
        this.contextSwitchers.add(wrapper);
        return wrapper;
    }

    @Override
    public void close() {
        this.contextSwitchers.forEach(ContextSwitcher::close);
    }

    @Override
    public String getFeatureDescription() {
        return FileUtils.getFileContent((InputStream)EmptyClass.class.getResourceAsStream("/sila_base/feature_definitions/org/silastandard/core/SimulationController.sila.xml"));
    }

    @Override
    public BindableService getService() {
        return this;
    }

    @Override
    public void startSimulationMode(SimulationControllerOuterClass.StartSimulationMode_Parameters request, StreamObserver<SimulationControllerOuterClass.StartSimulationMode_Responses> responseObserver) {
        this.simulation = true;
        responseObserver.onNext((Object)SimulationControllerOuterClass.StartSimulationMode_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void startRealMode(SimulationControllerOuterClass.StartRealMode_Parameters request, StreamObserver<SimulationControllerOuterClass.StartRealMode_Responses> responseObserver) {
        this.simulation = false;
        responseObserver.onNext((Object)SimulationControllerOuterClass.StartRealMode_Responses.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void getSimulationMode(SimulationControllerOuterClass.Get_SimulationMode_Parameters request, StreamObserver<SimulationControllerOuterClass.Get_SimulationMode_Responses> responseObserver) {
        responseObserver.onNext((Object)SimulationControllerOuterClass.Get_SimulationMode_Responses.newBuilder().setSimulationMode(SiLABoolean.from((boolean)this.simulation)).build());
        responseObserver.onCompleted();
    }

    public SimulationController(boolean simulation) {
        this.simulation = simulation;
    }

    public static final class ContextSwitcher<T extends Context>
    implements AutoCloseable {
        private final Provider<T> realProvider;
        private final T simulation;
        private T real;
        final /* synthetic */ SimulationController this$0;

        private ContextSwitcher(@NonNull Provider<T> realProvider, T simulation) {
            this.this$0 = this$0;
            if (realProvider == null) {
                throw new NullPointerException("realProvider is marked non-null but is null");
            }
            if (simulation == null) {
                throw new NullPointerException("simulation is marked non-null but is null");
            }
            this.realProvider = realProvider;
            this.simulation = simulation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getActive() {
            ContextSwitcher contextSwitcher = this;
            synchronized (contextSwitcher) {
                if (!this.this$0.simulation && this.real == null) {
                    this.real = (Context)this.realProvider.get();
                }
                return this.this$0.simulation ? this.simulation : this.real;
            }
        }

        @Override
        public void close() {
            if (this.real != null) {
                this.real.close();
                this.real = null;
            }
            this.simulation.close();
        }

        public Provider<T> getRealProvider() {
            return this.realProvider;
        }

        public T getSimulation() {
            return this.simulation;
        }

        public T getReal() {
            return this.real;
        }
    }

    public static interface Context
    extends AutoCloseable {
        @Override
        default public void close() {
        }
    }
}

