/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.database;

import io.grpc.Context;
import java.io.InputStream;
import java.time.Duration;
import java.util.UUID;
import lombok.NonNull;
import sila_java.library.core.sila.binary_transfer.BinaryInfo;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseInjector;

public interface BinaryDatabase
extends AutoCloseable {
    public Binary getBinary(UUID var1) throws BinaryDatabaseException;

    public BinaryInfo getBinaryInfo(UUID var1) throws BinaryDatabaseException;

    public Duration addBinary(@NonNull UUID var1, byte[] var2) throws BinaryDatabaseException;

    public Duration addBinary(UUID var1, InputStream var2) throws BinaryDatabaseException;

    public Duration extendBinaryExpiration(UUID var1) throws BinaryDatabaseException;

    public void removeAllBinaries() throws BinaryDatabaseException;

    public void removeBinary(UUID var1) throws BinaryDatabaseException;

    public static BinaryDatabase current() {
        return (BinaryDatabase)BinaryDatabaseInjector.BINARY_DATABASE_KEY.get(Context.current());
    }
}

