/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.config;

import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import lombok.NonNull;

@Immutable
public final class ServerConfiguration {
    private final String name;
    private final UUID uuid;

    public ServerConfiguration(@NonNull String serverName, UUID uuid) {
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
        if (serverName.length() > 255) {
            throw new IllegalArgumentException("SiLA Server Name must be shorter than 265 characters");
        }
        this.name = serverName;
        this.uuid = uuid;
    }

    public ServerConfiguration(@NonNull String serverName) {
        this(serverName, UUID.randomUUID());
        if (serverName == null) {
            throw new NullPointerException("serverName is marked non-null but is null");
        }
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

