/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.identification;

import lombok.NonNull;

public class ServerInformation {
    private final String type;
    private final String description;
    private final String vendorURL;
    private final String version;

    public ServerInformation(@NonNull String type, @NonNull String description, @NonNull String vendorURL, @NonNull String version) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (vendorURL == null) {
            throw new NullPointerException("vendorURL is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (!type.matches("[A-Z][a-zA-Z\\d]*")) {
            throw new IllegalArgumentException("SiLA Server Type must start with a capital letter and can only contain letters and digits (e.g. 'ExampleServerType123')");
        }
        if (!vendorURL.matches("https?://.+")) {
            throw new IllegalArgumentException("SiLA Server Vendor URL must start with 'https://' or 'http://'");
        }
        if (!version.matches("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(\\.(0|[1-9]\\d*))?(_\\w+)?")) {
            throw new IllegalArgumentException("SiLA Server Version does not follow the required pattern. Examples: '2.1', '0.1.3', '1.2.3_preview'");
        }
        this.type = type;
        this.description = description;
        this.vendorURL = vendorURL;
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVendorURL() {
        return this.vendorURL;
    }

    public String getVersion() {
        return this.version;
    }
}

