/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.download;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryDownloadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.core.sila.binary_transfer.BinaryInfo;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.types.SiLADuration;
import sila_java.library.server_base.binary_transfer.Binary;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;

public class DownloadService
extends BinaryDownloadGrpc.BinaryDownloadImplBase {
    private static final Logger log = LoggerFactory.getLogger(DownloadService.class);
    private final BinaryDatabase binaryDatabase;

    public void getBinaryInfo(SiLABinaryTransfer.GetBinaryInfoRequest request, StreamObserver<SiLABinaryTransfer.GetBinaryInfoResponse> responseObserver) {
        BinaryInfo binaryInfo;
        try {
            binaryInfo = this.binaryDatabase.getBinaryInfo(UUID.fromString(request.getBinaryTransferUUID()));
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)e.getMessage()));
            return;
        }
        responseObserver.onNext((Object)SiLABinaryTransfer.GetBinaryInfoResponse.newBuilder().setBinarySize(binaryInfo.getLength()).setLifetimeOfBinary(SiLADuration.from((Duration)Duration.between(OffsetDateTime.now(), binaryInfo.getExpiration()))).build());
        responseObserver.onCompleted();
    }

    public StreamObserver<SiLABinaryTransfer.GetChunkRequest> getChunk(final StreamObserver<SiLABinaryTransfer.GetChunkResponse> responseObserver) {
        return new StreamObserver<SiLABinaryTransfer.GetChunkRequest>(){

            public void onNext(SiLABinaryTransfer.GetChunkRequest request) {
                DownloadService.this.getChunk(request, (StreamObserver<SiLABinaryTransfer.GetChunkResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                log.warn("Download chunk stream exception: {}", (Object)t.getMessage(), (Object)t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private void getChunk(SiLABinaryTransfer.GetChunkRequest request, StreamObserver<SiLABinaryTransfer.GetChunkResponse> responseObserver) {
        UUID id;
        try {
            id = UUID.fromString(request.getBinaryTransferUUID());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)e.getMessage()));
            return;
        }
        try {
            Duration extendedExpiration = this.binaryDatabase.extendBinaryExpiration(id);
            Binary binary = this.binaryDatabase.getBinary(id);
            responseObserver.onNext((Object)SiLABinaryTransfer.GetChunkResponse.newBuilder().setPayload(ByteString.readFrom((InputStream)binary.getData().getBinaryStream(request.getOffset() + 1L, request.getLength()))).setOffset(request.getOffset()).setBinaryTransferUUID(request.getBinaryTransferUUID()).setLifetimeOfBinary(SiLADuration.from((Duration)extendedExpiration)).build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_DOWNLOAD_FAILED, (String)e.getMessage()));
        }
    }

    public void deleteBinary(SiLABinaryTransfer.DeleteBinaryRequest request, StreamObserver<SiLABinaryTransfer.DeleteBinaryResponse> responseObserver) {
        try {
            this.binaryDatabase.removeBinary(UUID.fromString(request.getBinaryTransferUUID()));
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)e.getMessage()));
            return;
        }
        responseObserver.onNext((Object)SiLABinaryTransfer.DeleteBinaryResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    public DownloadService(BinaryDatabase binaryDatabase) {
        this.binaryDatabase = binaryDatabase;
    }
}

