/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.upload;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;

public class BinaryUploadParameterWhitelistInterceptor
implements ServerInterceptor {
    private final Set<String> allowedParameters;

    public BinaryUploadParameterWhitelistInterceptor(List<String> allowedParameters) {
        for (String allowedParameter : allowedParameters) {
            if (FullyQualifiedIdentifierUtils.FullyQualifiedCommandParameterIdentifierPattern.matcher(allowedParameter).matches()) continue;
            throw new IllegalArgumentException(String.format("Not a fully qualified parameter identifier: '%s'", allowedParameter));
        }
        this.allowedParameters = new HashSet<String>(allowedParameters);
    }

    public BinaryUploadParameterWhitelistInterceptor(String ... allowedParameters) {
        this(Arrays.asList(allowedParameters));
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, final ServerCallHandler<ReqT, RespT> next) {
        if (!call.getMethodDescriptor().getFullMethodName().equals("sila2.org.silastandard.BinaryUpload/CreateBinary")) {
            return next.startCall(call, headers);
        }
        return new ForwardingServerCallListener<ReqT>(){
            private final ServerCall.Listener<ReqT> NOOP_LISTENER = new ServerCall.Listener<ReqT>(){};
            private ServerCall.Listener<ReqT> delegate = next.startCall(call, headers);

            protected ServerCall.Listener<ReqT> delegate() {
                return this.delegate;
            }

            public void onMessage(ReqT message) {
                SiLABinaryTransfer.CreateBinaryRequest request = (SiLABinaryTransfer.CreateBinaryRequest)message;
                String parameterIdentifier = request.getParameterIdentifier();
                if (!BinaryUploadParameterWhitelistInterceptor.this.allowedParameters.contains(parameterIdentifier)) {
                    call.close(BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)String.format("Binary upload is not allowed for parameter '%s'", parameterIdentifier)).getStatus(), headers);
                    this.delegate = this.NOOP_LISTENER;
                    return;
                }
                super.onMessage(message);
            }
        };
    }
}

