/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.binary_transfer.upload;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.BinaryUploadGrpc;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.types.SiLADuration;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabase;
import sila_java.library.server_base.binary_transfer.database.BinaryDatabaseException;
import sila_java.library.server_base.binary_transfer.upload.UploadCompletion;
import sila_java.library.server_base.binary_transfer.upload.UploadManager;

public class UploadService
extends BinaryUploadGrpc.BinaryUploadImplBase {
    private static final Logger log = LoggerFactory.getLogger(UploadService.class);
    private static final Duration MAX_UPLOAD_DURATION = Duration.ofMinutes(10L);
    private final UploadManager uploadManager = new UploadManager();
    private final BinaryDatabase binaryDatabase;

    public void createBinary(SiLABinaryTransfer.CreateBinaryRequest request, StreamObserver<SiLABinaryTransfer.CreateBinaryResponse> responseObserver) {
        UUID blobId = UUID.randomUUID();
        Duration expiration = MAX_UPLOAD_DURATION;
        this.uploadManager.addUpload(blobId, request.getBinarySize(), request.getChunkCount(), expiration);
        responseObserver.onNext((Object)SiLABinaryTransfer.CreateBinaryResponse.newBuilder().setLifetimeOfBinary(SiLADuration.from((Duration)expiration)).setBinaryTransferUUID(blobId.toString()).build());
        responseObserver.onCompleted();
    }

    public StreamObserver<SiLABinaryTransfer.UploadChunkRequest> uploadChunk(final StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver) {
        return new StreamObserver<SiLABinaryTransfer.UploadChunkRequest>(){

            public void onNext(SiLABinaryTransfer.UploadChunkRequest request) {
                UploadService.this.uploadChunk(request, (StreamObserver<SiLABinaryTransfer.UploadChunkResponse>)responseObserver);
            }

            public void onError(Throwable t) {
                log.warn("Upload chunk stream exception: {}", (Object)t.getMessage(), (Object)t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private void uploadChunk(SiLABinaryTransfer.UploadChunkRequest request, StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver) {
        Duration expiration;
        block14: {
            expiration = MAX_UPLOAD_DURATION;
            UUID blobId = UUID.fromString(request.getBinaryTransferUUID());
            try {
                UploadCompletion uploadCompletion = this.uploadManager.updateUpload(blobId, request.getChunkIndex(), request.getPayload().toByteArray(), expiration);
                if (!uploadCompletion.isComplete()) break block14;
                log.info("Upload {} from client complete", (Object)blobId);
                this.uploadManager.removeUpload(blobId);
                try (InputStream chunkStream = uploadCompletion.chunksToStream();){
                    expiration = this.binaryDatabase.addBinary(blobId, chunkStream);
                }
                uploadCompletion.close();
                this.uploadChunkResponse(request, responseObserver, expiration);
                responseObserver.onCompleted();
                return;
            }
            catch (IOException | BinaryDatabaseException e) {
                log.error("The following error occurred when attempting to save received chunk: {}", (Object)e.getMessage(), (Object)e);
                responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)e.getMessage()));
                return;
            }
        }
        this.uploadChunkResponse(request, responseObserver, expiration);
    }

    private void uploadChunkResponse(SiLABinaryTransfer.UploadChunkRequest request, StreamObserver<SiLABinaryTransfer.UploadChunkResponse> responseObserver, Duration newExpiration) {
        responseObserver.onNext((Object)SiLABinaryTransfer.UploadChunkResponse.newBuilder().setBinaryTransferUUID(request.getBinaryTransferUUID()).setChunkIndex(request.getChunkIndex()).setLifetimeOfBinary(SiLADuration.from((Duration)newExpiration)).build());
    }

    public void deleteBinary(SiLABinaryTransfer.DeleteBinaryRequest request, StreamObserver<SiLABinaryTransfer.DeleteBinaryResponse> responseObserver) {
        boolean partialUploadExists;
        boolean fullUploadExists;
        UUID binaryToDelete = UUID.fromString(request.getBinaryTransferUUID());
        try {
            this.binaryDatabase.getBinaryInfo(binaryToDelete);
            fullUploadExists = true;
        }
        catch (BinaryDatabaseException ex) {
            fullUploadExists = false;
        }
        boolean bl = partialUploadExists = this.uploadManager.getUpload(binaryToDelete) != null;
        if (!fullUploadExists && !partialUploadExists) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.INVALID_BINARY_TRANSFER_UUID, (String)String.format("No binary found with UUID %s", binaryToDelete)));
            return;
        }
        if (fullUploadExists) {
            try {
                this.binaryDatabase.removeBinary(binaryToDelete);
            }
            catch (BinaryDatabaseException ex) {
                responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)String.format("Failed to delete binary with UUID %s", binaryToDelete)));
                return;
            }
        }
        if (partialUploadExists && this.uploadManager.removeUpload(binaryToDelete) == null) {
            responseObserver.onError((Throwable)BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)String.format("Failed to delete binary with UUID %s", binaryToDelete)));
            return;
        }
        responseObserver.onNext((Object)SiLABinaryTransfer.DeleteBinaryResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    public UploadService(BinaryDatabase binaryDatabase) {
        this.binaryDatabase = binaryDatabase;
    }
}

