/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.command.observable;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.types.SiLAReal;
import sila_java.library.server_base.command.observable.ObservableCommandTaskRunner;
import sila_java.library.server_base.command.observable.RunnableCommandTask;

public class ObservableCommandWrapper<ParamType, ResultType>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObservableCommandWrapper.class);
    private final UUID executionId = UUID.randomUUID();
    private final ParamType parameter;
    private final Set<StreamObserver> stateObservers = ConcurrentHashMap.newKeySet();
    private final Set<StreamObserver> intermediateResponseObservers = ConcurrentHashMap.newKeySet();
    private final ExecutionInfo executionInfo = new ExecutionInfo();
    private final Duration lifeTimeOfExecution;
    private final RunnableCommandTask<ParamType, ResultType> task;
    private final Future<ResultType> future;
    private final ScheduledExecutorService scheduler;
    private final Consumer<UUID> expirationConsumer;

    ObservableCommandWrapper(@NonNull ParamType parameter, @NonNull RunnableCommandTask<ParamType, ResultType> task, @NonNull ObservableCommandTaskRunner runner, @NonNull Consumer<UUID> expirationConsumer, @NonNull ScheduledExecutorService scheduler) {
        this(parameter, task, runner, expirationConsumer, scheduler, null);
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (runner == null) {
            throw new NullPointerException("runner is marked non-null but is null");
        }
        if (expirationConsumer == null) {
            throw new NullPointerException("expirationConsumer is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
    }

    ObservableCommandWrapper(@NonNull ParamType param, @NonNull RunnableCommandTask<ParamType, ResultType> task, @NonNull ObservableCommandTaskRunner runner, @NonNull Consumer<UUID> expirationConsumer, @NonNull ScheduledExecutorService scheduler, @Nullable Duration lifeTimeOfExecution) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (runner == null) {
            throw new NullPointerException("runner is marked non-null but is null");
        }
        if (expirationConsumer == null) {
            throw new NullPointerException("expirationConsumer is marked non-null but is null");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is marked non-null but is null");
        }
        this.parameter = param;
        this.task = task;
        this.scheduler = scheduler;
        this.future = runner.enqueueTask(this::call);
        this.lifeTimeOfExecution = lifeTimeOfExecution;
        this.expirationConsumer = expirationConsumer;
    }

    public SiLAFramework.CommandConfirmation getCommandConfirmation() {
        SiLAFramework.CommandConfirmation.Builder builder = SiLAFramework.CommandConfirmation.newBuilder().setCommandExecutionUUID(SiLAFramework.CommandExecutionUUID.newBuilder().setValue(this.executionId.toString()).build());
        if (this.lifeTimeOfExecution != null) {
            builder.setLifetimeOfExecution(SiLAFramework.Duration.newBuilder().setSeconds(this.lifeTimeOfExecution.getSeconds()).setNanos(this.lifeTimeOfExecution.getNano()).build());
        }
        return builder.build();
    }

    public ResultType call() throws StatusRuntimeException {
        this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.running);
        try {
            ResultType result = this.task.run(this);
            if (result != null) {
                this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully);
                return result;
            }
        }
        catch (StatusRuntimeException e) {
            this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
            throw e;
        }
        catch (Throwable e) {
            log.warn("Error occurred during observable command {" + this.executionId + "} task execution", e);
            this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
            throw SiLAErrors.generateGenericExecutionError((Throwable)e);
        }
        this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
        throw SiLAErrors.generateDefinedExecutionError((String)"NoResult", (String)"No result was returned after end of command execution");
    }

    public void addStateObserver(@NonNull StreamObserver<SiLAFramework.ExecutionInfo> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        streamObserver.onNext((Object)this.getSiLAExecutionInfo());
        this.stateObservers.add(streamObserver);
    }

    public <IntermediateResultType> void addIntermediateResponseObserver(@NonNull StreamObserver<IntermediateResultType> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        this.intermediateResponseObservers.add(streamObserver);
    }

    public void sendResult(@NonNull StreamObserver<ResultType> streamObserver) {
        if (streamObserver == null) {
            throw new NullPointerException("streamObserver is marked non-null but is null");
        }
        if (this.future.isDone()) {
            try {
                streamObserver.onNext(this.future.get());
            }
            catch (StatusRuntimeException | InterruptedException | ExecutionException e) {
                streamObserver.onError(e);
            }
        } else {
            streamObserver.onError((Throwable)SiLAErrors.generateFrameworkError((SiLAFramework.FrameworkError.ErrorType)SiLAFramework.FrameworkError.ErrorType.COMMAND_EXECUTION_NOT_FINISHED, (String)"Command Execution is not finished. The result is not yet available."));
        }
        streamObserver.onCompleted();
    }

    public <IntermediateResultType> void notifyIntermediateResponse(@NonNull IntermediateResultType intermediateResponse) {
        if (intermediateResponse == null) {
            throw new NullPointerException("intermediateResponse is marked non-null but is null");
        }
        ObservableCommandWrapper.notifyIntermediateObservers(this.intermediateResponseObservers, intermediateResponse);
    }

    private static <IntermediateResultType> void notifyIntermediateObservers(Set<StreamObserver> intermediateResponseObservers, IntermediateResultType intermediateResponse) {
        Iterator<StreamObserver> it = intermediateResponseObservers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onNext(intermediateResponse);
            }
            catch (Exception e) {
                element.onError((Throwable)e);
                it.remove();
            }
        }
    }

    @Override
    public void close() {
        this.future.cancel(true);
        this.task.close();
        if (this.executionInfo.state != SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully) {
            this.setStateAndNotify(SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError);
        }
        ObservableCommandWrapper.closeObservers(this.stateObservers);
        this.stateObservers.clear();
        ObservableCommandWrapper.closeObservers(this.intermediateResponseObservers);
        this.intermediateResponseObservers.clear();
    }

    public boolean isDone() {
        return this.executionInfo.state == SiLAFramework.ExecutionInfo.CommandStatus.finishedWithError || this.executionInfo.state == SiLAFramework.ExecutionInfo.CommandStatus.finishedSuccessfully;
    }

    public void setExecutionInfoAndNotify(double progressionPercent, @Nullable Duration estimatedRemainingTime) {
        this.executionInfo.progressionPercent = progressionPercent;
        this.executionInfo.estimatedRemainingTime = estimatedRemainingTime;
        this.notifyState();
    }

    private void setStateAndNotify(@NonNull SiLAFramework.ExecutionInfo.CommandStatus state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.executionInfo.state = state;
        if (this.isDone() && this.lifeTimeOfExecution != null) {
            this.scheduler.schedule(() -> this.expirationConsumer.accept(this.executionId), this.lifeTimeOfExecution.toMillis(), TimeUnit.MILLISECONDS);
        }
        this.notifyState();
    }

    private void notifyState() {
        ObservableCommandWrapper.notifyObservers(this.stateObservers, this.getSiLAExecutionInfo());
    }

    private static <NotifyType> void notifyObservers(@NonNull Set<StreamObserver> observers, @NonNull NotifyType valueToNotify) {
        if (observers == null) {
            throw new NullPointerException("observers is marked non-null but is null");
        }
        if (valueToNotify == null) {
            throw new NullPointerException("valueToNotify is marked non-null but is null");
        }
        Iterator<StreamObserver> it = observers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onNext(valueToNotify);
            }
            catch (Exception e) {
                element.onError((Throwable)e);
                it.remove();
            }
        }
    }

    private static <NotifyType> void closeObservers(@NonNull Set<StreamObserver> observers) {
        if (observers == null) {
            throw new NullPointerException("observers is marked non-null but is null");
        }
        Iterator<StreamObserver> it = observers.iterator();
        while (it.hasNext()) {
            StreamObserver element = it.next();
            try {
                element.onCompleted();
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    private SiLAFramework.ExecutionInfo getSiLAExecutionInfo() {
        Duration remainingTime = this.executionInfo.estimatedRemainingTime;
        SiLAFramework.ExecutionInfo.Builder builder = SiLAFramework.ExecutionInfo.newBuilder().setCommandStatus(this.executionInfo.state).setProgressInfo(SiLAReal.from((double)this.executionInfo.progressionPercent));
        if (this.lifeTimeOfExecution != null) {
            builder.setUpdatedLifetimeOfExecution(SiLAFramework.Duration.newBuilder().setSeconds(this.lifeTimeOfExecution.getSeconds()).setNanos(this.lifeTimeOfExecution.getNano()).build());
        }
        if (remainingTime != null) {
            builder.setEstimatedRemainingTime(SiLAFramework.Duration.newBuilder().setSeconds(remainingTime.getSeconds()).setNanos(remainingTime.getNano()).build());
        }
        return builder.build();
    }

    public UUID getExecutionId() {
        return this.executionId;
    }

    public ParamType getParameter() {
        return this.parameter;
    }

    public Set<StreamObserver> getStateObservers() {
        return this.stateObservers;
    }

    public Set<StreamObserver> getIntermediateResponseObservers() {
        return this.intermediateResponseObservers;
    }

    ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    RunnableCommandTask<ParamType, ResultType> getTask() {
        return this.task;
    }

    Future<ResultType> getFuture() {
        return this.future;
    }

    static final class ExecutionInfo {
        private SiLAFramework.ExecutionInfo.CommandStatus state = SiLAFramework.ExecutionInfo.CommandStatus.waiting;
        private double progressionPercent = 0.0;
        private Duration estimatedRemainingTime = null;

        ExecutionInfo() {
        }

        SiLAFramework.ExecutionInfo.CommandStatus getState() {
            return this.state;
        }
    }
}

