/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.metadata;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import sila2.org.silastandard.SiLABinaryTransfer;
import sila_java.library.core.sila.binary_transfer.BinaryTransferErrorHandler;
import sila_java.library.core.sila.errors.SiLAErrorException;
import sila_java.library.core.sila.errors.SiLAErrors;
import sila_java.library.core.sila.utils.FullyQualifiedIdentifierUtils;
import sila_java.library.server_base.metadata.ServerMetadataContainer;

public abstract class MetadataInterceptor
implements ServerInterceptor {
    private final List<Pattern> affectedCallTargetPatterns;
    private final List<String> affectedCallIdentifiers;

    public abstract <ReqT, RespT> Context intercept(ServerCall<ReqT, RespT> var1, ServerMetadataContainer var2);

    public MetadataInterceptor(@NonNull List<String> affectedCalls) {
        if (affectedCalls == null) {
            throw new NullPointerException("affectedCalls is marked non-null but is null");
        }
        this.affectedCallIdentifiers = new ArrayList<String>(affectedCalls);
        this.affectedCallTargetPatterns = MetadataInterceptor.getAffectedCallTargetPatterns(affectedCalls);
    }

    public MetadataInterceptor(@NonNull String affectedCall) {
        this(Collections.singletonList(affectedCall));
        if (affectedCall == null) {
            throw new NullPointerException("affectedCall is marked non-null but is null");
        }
    }

    public final <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, final ServerCallHandler<ReqT, RespT> next) {
        String callTarget = call.getMethodDescriptor().getFullMethodName();
        if (callTarget.equals("sila2.org.silastandard.BinaryUpload/CreateBinary")) {
            return new ForwardingServerCallListener<ReqT>(){
                private final ServerCall.Listener<ReqT> NOOP_LISTENER = new ServerCall.Listener<ReqT>(){};
                private ServerCall.Listener<ReqT> delegate = next.startCall(call, headers);

                protected ServerCall.Listener<ReqT> delegate() {
                    return this.delegate;
                }

                public void onMessage(ReqT message) {
                    SiLABinaryTransfer.CreateBinaryRequest request = (SiLABinaryTransfer.CreateBinaryRequest)message;
                    if (MetadataInterceptor.this.affectedCallIdentifiers.stream().anyMatch(identifier -> request.getParameterIdentifier().startsWith((String)identifier))) {
                        try {
                            MetadataInterceptor.this.intercept(call, MetadataInterceptor.this.getMetadata(headers));
                        }
                        catch (Exception e) {
                            if (e instanceof StatusRuntimeException) {
                                call.close(((StatusRuntimeException)((Object)e)).getStatus(), headers);
                            } else {
                                call.close(BinaryTransferErrorHandler.generateBinaryTransferError((SiLABinaryTransfer.BinaryTransferError.ErrorType)SiLABinaryTransfer.BinaryTransferError.ErrorType.BINARY_UPLOAD_FAILED, (String)e.getMessage()).getStatus(), headers);
                            }
                            this.delegate = this.NOOP_LISTENER;
                            return;
                        }
                    }
                    super.onMessage(message);
                }
            };
        }
        if (this.affectedCallTargetPatterns.stream().noneMatch(pattern -> pattern.matcher(callTarget).matches())) {
            return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
        }
        try {
            Context newContext = this.intercept(call, this.getMetadata(headers));
            return Contexts.interceptCall((Context)newContext, call, (Metadata)headers, next);
        }
        catch (Throwable e) {
            call.close(new SiLAErrorException(SiLAErrors.throwableToSiLAError((Throwable)e)).getStatus(), headers);
            return new ServerCall.Listener<ReqT>(){};
        }
    }

    private ServerMetadataContainer getMetadata(Metadata headers) {
        if (ServerMetadataContainer.current() == null) {
            return ServerMetadataContainer.fromHeaders(headers);
        }
        return ServerMetadataContainer.current();
    }

    private static List<Pattern> getAffectedCallTargetPatterns(@NonNull List<String> affectedCalls) {
        if (affectedCalls == null) {
            throw new NullPointerException("affectedCalls is marked non-null but is null");
        }
        return affectedCalls.stream().map(MetadataInterceptor::getAffectedCallTargetPattern).collect(Collectors.toList());
    }

    private static Pattern getAffectedCallTargetPattern(String affectedCall) {
        Matcher featureIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedFeatureIdentifierPattern.matcher(affectedCall);
        Matcher commandIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedCommandIdentifierPattern.matcher(affectedCall);
        Matcher propertyIdentifierMatcher = FullyQualifiedIdentifierUtils.FullyQualifiedPropertyIdentifierPattern.matcher(affectedCall);
        if (!(featureIdentifierMatcher.matches() || commandIdentifierMatcher.matches() || propertyIdentifierMatcher.matches())) {
            throw new IllegalArgumentException(String.format("Given argument is no fully qualified feature, command, or property identifier: '%s'", affectedCall));
        }
        String[] affectedCallElements = affectedCall.split("/");
        String originator = affectedCallElements[0];
        String category = affectedCallElements[1];
        String featureIdentifier = affectedCallElements[2];
        String majorVersion = affectedCallElements[3];
        String callPrefix = String.join((CharSequence)"\\.", "sila2", originator, category, featureIdentifier.toLowerCase(), majorVersion, featureIdentifier);
        callPrefix = commandIdentifierMatcher.matches() ? callPrefix + "/" + affectedCall.split("/")[5] : (propertyIdentifierMatcher.matches() ? callPrefix + "/(Get_|Subscribe_)" + affectedCall.split("/")[5] : callPrefix + "/(Get_|Subscribe_)?[A-Z][a-zA-Z0-9]*");
        return Pattern.compile(callPrefix);
    }
}

