/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.server_base.metadata;

import com.google.protobuf.Message;
import io.grpc.Context;
import io.grpc.Metadata;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import sila_java.library.core.sila.utils.MetadataUtils;
import sila_java.library.server_base.metadata.MetadataExtractingInterceptor;

public class ServerMetadataContainer {
    private static final String grpcMetadataKeyPrefix = "sila-";
    private static final String grpcMetadataKeySuffix = "-bin";
    private final Map<String, byte[]> rawMetadata;

    private ServerMetadataContainer(Map<String, byte[]> rawMetadata) {
        this.rawMetadata = rawMetadata;
    }

    public static ServerMetadataContainer fromHeaders(Metadata headers) {
        HashMap<String, byte[]> rawMetadata = new HashMap<String, byte[]>();
        headers.keys().stream().filter(key -> key.startsWith(grpcMetadataKeyPrefix) && key.endsWith(grpcMetadataKeySuffix)).forEach(key -> {
            byte[] cfr_ignored_0 = (byte[])rawMetadata.put((String)key, (byte[])headers.get(Metadata.Key.of((String)key, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER)));
        });
        return new ServerMetadataContainer(rawMetadata);
    }

    public static ServerMetadataContainer current() {
        return (ServerMetadataContainer)MetadataExtractingInterceptor.SILA_METADATA_KEY.get(Context.current());
    }

    public <T extends Message> T get(Class<T> metadataMessageClass) {
        String grpcMetadataKey = MetadataUtils.metadataProtobufMessageClassToGrpcMetadataKey(metadataMessageClass);
        byte[] messageBytes = this.rawMetadata.get(grpcMetadataKey);
        if (messageBytes == null) {
            return null;
        }
        try {
            Method parseMethod = metadataMessageClass.getMethod("parseFrom", byte[].class);
            return (T)((Message)parseMethod.invoke(null, new Object[]{messageBytes}));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Given message class does not have a method parseFrom(byte[])");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Method parseFrom(byte[]) threw an exception", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Runtime cannot access method parseFrom(byte[])");
        }
    }
}

