# Contributing

Find an area you can help with and do it. Open source is about collaboration and open participation. Try to make your code
look like what already exists and submit a merge request.

The [list of issues](https://gitlab.com/groups/SiLA2/-/boards/539734) is a good place to start, especially the ones tagged as 
"help wanted" (but don't let that stop you from looking at others). If you're looking for additional ideas, the code includes 
`TODO` comments for minor to major improvements. Grep is your friend.

## Find a task/issue to tackle

2. Find an issue to tackle in the [Open Issues](https://gitlab.com/groups/SiLA2/-/boards/539734) list
2. Notify `#development` slack channel that you will be working on this issue (see instructions to [Join Us](#join-us))
3. Assign yourself to the issue
4. Change the issue label to *Todo*

**Note:** If you cant find an issue for the task you would like to work on, feel free to just create an MR or create 
a new issue by going [here](https://gitlab.com/groups/SiLA2/-/issues) to open some discussion.

Additional tests are rewarded with an immense amount of positive karma.

More documentation or updates/fixes to existing documentation are also very welcome. However, if submitting a MR (Merge-Request) 
consisting of documentation changes only, please try to ensure that the change is significantly more substantial than one or two lines.
For example, working through an install document and making changes and updates throughout as you find issues is worth a PR. 
For typos and other small changes, either contact one of the developers, or if you think it's a significant enough error to cause 
problems for other users, please feel free to open an issue.

# Join Us

If any help is needed during your effort to contribute on this project, please don't hesitate to join our community:


**Join the SiLA2 Slack Community**

Sign up to the [slack](https://join.slack.com/t/sila-standard/shared_invite/enQtNDI0ODcxMDg5NzkzLTc4YjdkNzgxYjM5NDIyMzAyNTJjMjE1ZWI5MzY0M2Y2NmY3ZGQ2NTI3YzJiMmIzNTFmZmJkMWI3ZTMyMTk5NGY) community and join the `#development` channel.

**Join the Gitlab SiLA2 developer group**

Request `developer` access to the [SiLA2 Group](https://gitlab.com/SiLA2) via the `#development` slack channel


# Merge-Request Guidelines

## Title
**Note**: *[draft part! to be reviewed and discussed]*

Please consider putting one of the following prefixes in the title of your merge-request:
- **Add**:     A new feature
- **Change**:  A code change that neither fixes a bug nor adds a feature
- **Fix**:     A bug fix
- **Remove**:    Formatting, missing semi-colons, white-space, etc
- **Test**:     Adding missing tests
- **Chore**:    Maintain. Changes to the build process or auxiliary tools/libraries/documentation

For example: `Fix: a panick on xxx when server closes`. Please don't worry if you can't find a suitable prefix, this's just optional, not mandatory.

### Thanks for any contribution
Even one word correction are welcome! Our objective is to encourage you to get interested in SiLA2 and contribute in any way possible. Thanks for any help!
