/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.utils;

import com.github.sarxos.winreg.HKey;
import com.github.sarxos.winreg.RegistryException;
import com.github.sarxos.winreg.WindowsRegistry;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRegistryUtility {
    private static final Logger log = LoggerFactory.getLogger(WinRegistryUtility.class);

    public static boolean isWindows() throws RegistryException {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    public static void fixRegistry() throws RegistryException {
        String PREF_KEY_LOC_64 = "Software\\WOW6432Node\\JavaSoft";
        String PREF_KEY_LOC_32 = "Software\\JavaSoft";
        String PREF_KEY_NAME = "Prefs";
        String result = WinRegistryUtility.searchForKey(HKey.HKLM, "Software\\JavaSoft", "Prefs");
        if (result == null) {
            if (WinRegistryUtility.isAdmin()) {
                WinRegistryUtility.writeKey(HKey.HKLM, "Software\\JavaSoft\\Prefs");
                WinRegistryUtility.writeKey(HKey.HKLM, "Software\\WOW6432Node\\JavaSoft\\Prefs");
            } else {
                log.warn("Java Registry is missing 'Prefs' key. \nThis is NOT critical! \nPlease execute once as ADMIN and we will create it for you. \nYou only need to start as an ADMIN once. \nProceeding with normal execution...");
            }
        }
    }

    private static boolean isAdmin() {
        Preferences prefs = Preferences.systemRoot();
        try {
            prefs.put("foo", "bar");
            prefs.remove("foo");
            prefs.flush();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public static boolean is64BitWindows() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    public static String readStringLM(String path, String name) throws RegistryException {
        return WinRegistryUtility.readString(HKey.HKLM, path, name);
    }

    public static String readString(HKey key, String path, String name) throws RegistryException {
        return WindowsRegistry.getInstance().readString(key, path, name);
    }

    public void writeString(HKey key, String path, String valueName, String value) throws RegistryException {
        WindowsRegistry.getInstance().writeStringValue(key, path, valueName, value);
    }

    public static void writeKey(HKey hk, String key) throws RegistryException {
        WindowsRegistry.getInstance().createKey(hk, key);
    }

    public static String searchForKeyLM(String path, String name) throws RegistryException {
        return WinRegistryUtility.searchForKey(HKey.HKLM, path, name);
    }

    public static String searchForKey(HKey root, String path, String name) throws RegistryException {
        List keys = WindowsRegistry.getInstance().readStringSubKeys(root, path);
        for (String folder : keys) {
            String newPath;
            log.debug("[findFirstRecursive] check: .. {}", (Object)folder);
            String string = newPath = path.length() == 0 ? folder : path + "\\" + folder;
            if (folder.equals(name)) {
                return newPath;
            }
            String found = WinRegistryUtility.searchForKey(root, newPath, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

