/*
 * Decompiled with CFR 0.152.
 */
package sila_java.library.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtil.class);

    public static Optional<ProcessInfo> findProcessesByName(String name) {
        return JProcesses.get().fastMode().listProcesses().parallelStream().filter(p -> p.getCommand().contains(name)).findFirst();
    }

    public static Process startProcess(String ... command) throws IOException {
        ProcessBuilder p = new ProcessBuilder(new String[0]);
        p.command(command);
        Process process = p.start();
        StreamGobbler inputGobbler = new StreamGobbler(process.getInputStream(), System.out);
        StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), System.err);
        inputGobbler.start();
        errorGobbler.start();
        return process;
    }

    private static class StreamGobbler
    extends Thread {
        private InputStream in;
        private PrintStream out;

        private StreamGobbler(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader input = new BufferedReader(new InputStreamReader(this.in));
                while ((line = input.readLine()) != null) {
                    this.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class ProcessMonitor
    implements Runnable {
        private static final long MONITOR_PERIOD = Duration.ofSeconds(30L).toMillis();
        private final List<String> processNames;
        private final List<ProcessListener> listeners = new CopyOnWriteArrayList<ProcessListener>();
        private final Thread monitorThread;
        private final JProcesses jProcesses = JProcesses.get().fastMode();
        private boolean keepRunning = true;

        public ProcessMonitor(List<String> processNames) {
            this.processNames = processNames;
            this.monitorThread = new Thread((Runnable)this, "ProcessMonitor");
        }

        public void addListener(ProcessListener listener) {
            this.listeners.add(listener);
        }

        public void startMonitoring() {
            this.monitorThread.start();
        }

        public boolean allProcessesRunning() {
            return this.getRunningProcesses().containsAll(this.processNames);
        }

        @Override
        public void run() {
            this.keepRunning = true;
            while (this.keepRunning) {
                log.debug("[run] monitoring processes");
                List<String> processes = this.getRunningProcesses();
                for (String processName : this.processNames) {
                    if (processes.contains(processName)) {
                        log.debug("Process {} found!", (Object)processName);
                        continue;
                    }
                    log.info("Process {} not found!", (Object)processName);
                    for (ProcessListener listener : this.listeners) {
                        listener.onProcessDown(processName);
                    }
                }
                try {
                    Thread.sleep(MONITOR_PERIOD);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void stopMonitoring() {
            this.keepRunning = false;
            Thread.currentThread().interrupt();
        }

        private List<String> getRunningProcesses() {
            return this.jProcesses.listProcesses().stream().map(ProcessInfo::getCommand).collect(Collectors.toList());
        }
    }

    public static interface ProcessListener {
        public void onProcessDown(String var1);
    }
}

