/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.barcode_reader;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.servers.barcode_reader.BarcodeNotFoundException;
import sila_java.servers.barcode_reader.MCR12USBReading;

public class BarcodeReaderDriver {
    private static final Logger log = LoggerFactory.getLogger(BarcodeReaderDriver.class);
    private static final Pin RASPI_PIN = RaspiPin.GPIO_29;
    private final GpioController gpio = GpioFactory.getInstance();
    private final GpioPinDigitalOutput gpioPin;

    public BarcodeReaderDriver() {
        this.gpio.setShutdownOptions(Boolean.valueOf(true), PinState.LOW, new GpioPin[0]);
        this.gpioPin = this.gpio.provisionDigitalOutputPin(RASPI_PIN, "Barcode_Trigger", PinState.LOW);
    }

    public synchronized String getBarcode(long timeout) throws BarcodeNotFoundException {
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<String> future = executor.submit(MCR12USBReading::getBarcode);
        this.gpioPin.high();
        String result = null;
        try {
            result = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error(e.getMessage());
            throw new BarcodeNotFoundException("No barcode found within " + String.valueOf(timeout) + " seconds.");
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.getMessage());
            throw new BarcodeNotFoundException("Failed unexpectedly.");
        }
        finally {
            future.cancel(true);
            this.gpioPin.low();
        }
        if (result == null || result.isEmpty()) {
            throw new BarcodeNotFoundException("No barcode found");
        }
        if (result.trim().isEmpty()) {
            throw new BarcodeNotFoundException("Barcode was in unexpected format. Ensure that the 1D barcode is in supported format.");
        }
        return result;
    }

    public static void main(String[] args) {
        BarcodeReaderDriver barcodeReaderDriver = new BarcodeReaderDriver();
        try {
            String result = barcodeReaderDriver.getBarcode(1L);
            System.out.println("Barcode found: " + result);
        }
        catch (BarcodeNotFoundException e) {
            System.out.println("No barcode found: " + e.getMessage());
        }
    }
}

