/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.barcode_reader;

import io.grpc.BindableService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.utils.SocketUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServerBase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.servers.barcode_reader.BarcodeReaderDriver;
import sila_java.servers.barcode_reader.BarcodeReaderServer;

public class BarcodeReaderServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BarcodeReaderServer.class);
    public static final String SERVER_TYPE = "BarcodeReaderMCR12";
    private static final int SERVER_PORT = 50052;
    private static final int SERVER_PORT_RANGE = 256;
    private static final int FIXED_TIMEOUT = 1;
    private static final int MAX_TIMEOUT = 20;
    private final BarcodeReaderDriver barcodeReaderDriver = new BarcodeReaderDriver();
    private final SiLAServerBase siLAServerBase;

    public BarcodeReaderServer(@NonNull String interfaceName, int serverPort, @Nullable Path config) {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        try {
            1 fdl = new /* Unavailable Anonymous Inner Class!! */;
            ServerInformation serverInfo = new ServerInformation(SERVER_TYPE, "A small, camera-based barcode reader with red illumination. Reads most barcode standards.", "www.unitelabs.ch", "v0.0");
            this.siLAServerBase = config == null ? SiLAServerBase.withoutConfig((ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new ReaderImpl(this)}) : SiLAServerBase.withConfig((Path)config, (ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new ReaderImpl(this)});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.siLAServerBase.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        int serverPort = argumentHelper.getPort() != null ? argumentHelper.getPort() : SocketUtils.getAvailablePortInRange((int)50052, (int)50308);
        try (BarcodeReaderServer server = new BarcodeReaderServer(argumentHelper.getInterface(), serverPort, (Path)argumentHelper.getConfigFile().orElse(null));){
            Utils.blockUntilStop();
        }
        System.out.println("termination complete.");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ BarcodeReaderDriver access$100(BarcodeReaderServer x0) {
        return x0.barcodeReaderDriver;
    }
}

