package sila_java.servers.bioshake;

import io.grpc.ManagedChannel;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.shakecontroller.v1.ShakeControllerGrpc;
import sila2.org.silastandard.core.shakecontroller.v1.ShakeControllerOuterClass;
import sila_java.library.core.discovery.SiLAServerDiscovery;
import sila_java.library.manager.SiLAManager;
import sila_java.library.manager.server_management.ServerUtilities;

import java.util.concurrent.TimeUnit;

/**
 * Client to call BioShaker Server
 */
public class BioShakeClient {
    public static void main(String[] args) throws Exception {
        final SiLAManager siLAManager = SiLAManager.getInstance();
        siLAManager.startDiscovery();

        // Blocking call to find server, then connect to the first one found
        siLAManager.blockUntilServerFound(BioShakeServer.SERVER_TYPE, Integer.MAX_VALUE);

        final ManagedChannel channel =
                ServerUtilities.buildNewChannel(siLAManager.getSiLAServersByName(BioShakeServer.SERVER_TYPE).get(0));
        final ShakeControllerGrpc.ShakeControllerBlockingStub blockingStub =
                ShakeControllerGrpc.newBlockingStub(channel);

        // Call the server and try to shake
        try {
            blockingStub.shakePredetermined(ShakeControllerOuterClass.ShakePredetermined_Parameters.newBuilder()
                    .setDuration(SiLAFramework.Integer.newBuilder().setValue(10)) // one second
                    .setTargetSpeed(
                        ShakeControllerOuterClass.DataType_Speed.newBuilder().setSpeed(
                                SiLAFramework.Integer.newBuilder().setValue(200)
                        ).build()
                    )
                    .setTargetAccelerationDuration(
                            ShakeControllerOuterClass.DataType_AccelerationDuration.newBuilder()
                                    .setAccelerationDuration(
                                            SiLAFramework.Integer.newBuilder().setValue(5)
                                    ).build()
                    )
                    .build());
        } finally {
            SiLAServerDiscovery.getInstance().stop();
            channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
        }
    }
}