/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.bioshake;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.communication.CommunicationSocket;
import sila_java.library.core.communication.SerialCommunication;
import sila_java.library.core.communication.SynchronousCommunication;
import sila_java.servers.bioshake.BioShakeErrorHelper;
import sila_java.servers.bioshake.BioShakeUtils;
import sila_java.servers.bioshake.exceptions.BioShakeException;
import sila_java.servers.bioshake.exceptions.DriverException;

class BioShakeDriver {
    private static final Logger log = LoggerFactory.getLogger(BioShakeDriver.class);
    private final SynchronousCommunication synchronousCommunication;
    private static final int SAMPLING_TIME = 2000;
    private static final int INPUT_TIMEOUT = 10000;
    private static final List<String> NON_BOOTING_STATES = Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7");
    private static final String DELIMITER = "\r\n";
    private static final int SLEEP_TIME = 1000;
    private static final String ERROR_MESSAGE_FORMAT = "e";
    static final long ACCELERATION_MAX = 30L;
    static final long ACCELERATION_MIN = 0L;
    static final long DURATION_MAX = 99999L;
    static final long DURATION_MIN = 0L;
    static final long RPM_MAX = 3000L;
    static final long RPM_MIN = 200L;
    private static final String DEVICE_SERIAL_NAME = "BIOSHAKE 3000";
    private int currentVelocity = 0;
    private int currentAcceleration = 0;

    BioShakeDriver(@Nonnull String serialComName) {
        this.synchronousCommunication = new SynchronousCommunication((CommunicationSocket)new SerialCommunication(serialComName));
        this.synchronousCommunication.startHeartbeat(2000, () -> {
            try {
                String result = this.synchronousCommunication.sendReceive("getShakeState", DELIMITER, 10000L).replaceAll("([\\r\\n\\t])", "");
                boolean booted = NON_BOOTING_STATES.contains(result);
                if (!booted) {
                    return false;
                }
                String version = this.synchronousCommunication.sendReceive("getDescription", DELIMITER, 10000L);
                return version.contains(DEVICE_SERIAL_NAME);
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    public void shutdown() {
        this.synchronousCommunication.shutdown();
    }

    private boolean isDriverUp() {
        return this.synchronousCommunication != null && this.synchronousCommunication.isUp();
    }

    private synchronized String sendReceive(String msg) throws IOException, DriverException {
        String result = this.synchronousCommunication.sendReceive(msg, DELIMITER, 10000L);
        if ((result = result.replaceAll("([\\r\\n\\t])", "")).equals(ERROR_MESSAGE_FORMAT)) {
            throw new BioShakeException("Error encountered, please check the Error List or the State");
        }
        if (result.contains("u -> ")) {
            throw new DriverException.CommandNotFoundException(msg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String shakeOff() throws IOException, DriverException {
        String result;
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        BioShakeDriver bioShakeDriver = this;
        synchronized (bioShakeDriver) {
            result = this.sendReceive("shakeOff");
            while (!this.testIfShakeFinished()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("[shake] Driver Interrupted. " + e.getMessage());
                }
            }
            this.setElmUnlockPos();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String shakeIndefinitely() throws IOException, DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        if (!this.testIfShakeFinished()) {
            throw new DriverException.AlreadyShakingException();
        }
        BioShakeDriver bioShakeDriver = this;
        synchronized (bioShakeDriver) {
            if (this.currentVelocity == 0) {
                throw new BioShakeException("Please set Target Speed first.");
            }
            this.setElmLockPos();
            this.sendReceive("setShakeTargetSpeed" + this.currentVelocity);
            this.sendReceive("setShakeAcceleration" + this.currentAcceleration);
            return this.sendReceive("shakeOn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String shakePredetermined(int duration, int velocity, int acceleration) throws IOException, DriverException {
        String result;
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        if (!this.testIfShakeFinished()) {
            throw new DriverException.AlreadyShakingException();
        }
        BioShakeDriver bioShakeDriver = this;
        synchronized (bioShakeDriver) {
            this.setElmLockPos();
            this.currentVelocity = velocity;
            this.currentAcceleration = acceleration;
            this.sendReceive("setShakeTargetSpeed" + velocity);
            this.sendReceive("setShakeAcceleration" + acceleration);
            result = this.sendReceive("shakeOnWithRuntime" + duration);
        }
        while (!this.testIfShakeFinished()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.setElmUnlockPos();
        return result;
    }

    void setShakeTargetSpeed(int velocity) throws DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        this.currentVelocity = velocity;
    }

    void setShakeAcceleration(int acceleration) throws DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        this.currentAcceleration = acceleration;
    }

    String getState() throws IOException, DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        String result = this.sendReceive("getShakeState");
        return BioShakeUtils.getStateMessage((int)Integer.parseInt(result));
    }

    List<String> getErrorList() throws IOException, DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        return BioShakeErrorHelper.mapStringErrorsToList((String)this.sendReceive("getErrorList"));
    }

    String getVersion() throws IOException, DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        return this.sendReceive("getVersion");
    }

    String getDescription() throws IOException, DriverException {
        if (!this.isDriverUp()) {
            throw new DriverException.DeviceNotRunningException();
        }
        return this.sendReceive("getDescription");
    }

    private boolean testIfShakeFinished() throws IOException, DriverException {
        String result = this.sendReceive("getShakeState");
        BioShakeUtils.DeviceState deviceState = BioShakeUtils.getDeviceState((int)Integer.parseInt(result));
        log.info("[shaking test]: #{} => {}", (Object)result, (Object)deviceState.state.getMessage());
        return deviceState.equals((Object)BioShakeUtils.DeviceState.HOME);
    }

    private void setElmLockPos() throws IOException, DriverException {
        BioShakeUtils.ELMStatePosition elmStatePos = BioShakeUtils.getELMStatePosition((int)Integer.parseInt(this.sendReceive("getElmState")));
        while (!elmStatePos.equals((Object)BioShakeUtils.ELMStatePosition.LOCKED)) {
            log.info("[closeElm][auto-close ELM] getElmState: {}", (Object)elmStatePos.message);
            if (elmStatePos.equals((Object)BioShakeUtils.ELMStatePosition.ERROR)) {
                throw new BioShakeException("Locking Error: " + elmStatePos.message);
            }
            String lockResult = this.sendReceive("setElmLockPos");
            log.info("[closeElm][auto-close ELM] setElmLockPos: {}", (Object)lockResult);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage());
            }
            elmStatePos = BioShakeUtils.getELMStatePosition((int)Integer.parseInt(this.sendReceive("getElmState")));
        }
        log.info("[closeElm][auto-close ELM] setElmLockPos: {}", (Object)elmStatePos.message);
    }

    private String setElmUnlockPos() throws IOException, DriverException {
        BioShakeUtils.ELMStatePosition elmStatePos = BioShakeUtils.getELMStatePosition((int)Integer.parseInt(this.sendReceive("getElmState")));
        while (!elmStatePos.equals((Object)BioShakeUtils.ELMStatePosition.UNLOCKED)) {
            log.info("[openElm][auto-open ELM] getElmState: {}", (Object)elmStatePos.message);
            if (elmStatePos.equals((Object)BioShakeUtils.ELMStatePosition.ERROR)) {
                return elmStatePos.message;
            }
            try {
                if (!this.isDriverUp()) {
                    throw new DriverException.DeviceInterrupted();
                }
            }
            catch (DriverException e) {
                return "Driver is down.";
            }
            String unlockResult = this.sendReceive("setElmUnlockPos");
            log.info("[openElm][auto-open ELM] setElmUnlockPos: {}", (Object)unlockResult);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage());
            }
            elmStatePos = BioShakeUtils.getELMStatePosition((int)Integer.parseInt(this.sendReceive("getElmState")));
        }
        log.info("[openElm][auto-open ELM] setElmUnlockPos: {}", (Object)elmStatePos.message);
        return elmStatePos.message;
    }
}

