/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.bioshake;

import io.grpc.BindableService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.communication.utils.ListSerialComInterfaces;
import sila_java.library.core.utils.SocketUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServerBase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.servers.bioshake.BioShakeDriver;
import sila_java.servers.bioshake.BioShakeServer;

public class BioShakeServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BioShakeServer.class);
    static final String SERVER_TYPE = "BioShake";
    private static final int SERVER_PORT = 50051;
    private static final int SERVER_PORT_RANGE = 256;
    private final SiLAServerBase siLAServerBase;
    private final BioShakeDriver driver;

    public BioShakeServer(@NonNull String interfaceName, int serverPort, @NonNull String serialComName, @Nullable Path config) {
        1 fdl;
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        if (serialComName == null) {
            throw new NullPointerException("serialComName");
        }
        try {
            fdl = new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.driver = new BioShakeDriver(serialComName);
        ServerInformation serverInfo = new ServerInformation(SERVER_TYPE, "The BioShake provides high-speed mixing action and temperature control for the most demanding robotics applications.", "www.QInstruments.com", "v0.0");
        try {
            this.siLAServerBase = config == null ? SiLAServerBase.withoutConfig((ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new StateImpl(this), new ShakeImpl(this)}) : SiLAServerBase.withConfig((Path)config, (ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new StateImpl(this), new ShakeImpl(this)});
        }
        catch (IOException e) {
            this.driver.shutdown();
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)BioShakeDriver.class.toString()).build().defaultHelp(true).description("BioShake server has defaults and some options.");
        parser.addArgument(new String[]{"-s", "--serialCom"}).type(String.class).setDefault((Object)"USB-to-Serial Port").help("Specify serial communication name for the driver to find the proper one. It might change from OS to OS.");
        parser.addArgument(new String[]{"-u", "--listUsb"}).type((ArgumentType)Arguments.booleanType((String)"yes", (String)"no")).setDefault((Object)false).help("List of names of USB-Serial interfaces found");
        ArgumentHelper argumentHelper = new ArgumentHelper(args, "BioShakeServer", parser);
        int serverPort = argumentHelper.getPort() != null ? argumentHelper.getPort() : SocketUtils.getAvailablePortInRange((int)50051, (int)50307);
        boolean listMode = argumentHelper.getNs().getBoolean("listUsb");
        if (listMode) {
            ListSerialComInterfaces.display();
            System.exit(0);
        }
        String serialComName = argumentHelper.getNs().getString("serialCom");
        try (BioShakeServer server = new BioShakeServer(argumentHelper.getInterface(), serverPort, serialComName, (Path)argumentHelper.getConfigFile().orElse(null));){
            Utils.blockUntilStop();
        }
        log.info("termination complete.");
    }

    @Override
    public void close() {
        this.siLAServerBase.close();
        this.driver.shutdown();
    }

    static /* synthetic */ BioShakeDriver access$000(BioShakeServer x0) {
        return x0.driver;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

