/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.file_server;

import io.grpc.BindableService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.utils.SocketUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServerBase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.servers.file_server.FileServer;

public class FileServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(FileServer.class);
    static final String SERVER_TYPE = "FileServer";
    static final int SERVER_PORT = 50052;
    private static final int SERVER_PORT_RANGE = 256;
    private final SiLAServerBase siLAServerBase;

    public FileServer(@NonNull String interfaceName, int serverPort, @Nullable Path config) {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        try {
            1 fdl = new /* Unavailable Anonymous Inner Class!! */;
            ServerInformation serverInfo = new ServerInformation(SERVER_TYPE, "File Server", "www.unitelabs.ch", "v0.0");
            this.siLAServerBase = config == null ? SiLAServerBase.withoutConfig((ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new FileCreatorImpl()}) : SiLAServerBase.withConfig((Path)config, (ServerInformation)serverInfo, (Map)fdl, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new FileCreatorImpl()});
            log.info("File Server successfully created");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        int serverPort = argumentHelper.getPort() != null ? argumentHelper.getPort() : SocketUtils.getAvailablePortInRange((int)50052, (int)50308);
        try (FileServer server = new FileServer(argumentHelper.getInterface(), serverPort, (Path)argumentHelper.getConfigFile().orElse(null));){
            Utils.blockUntilStop();
        }
        System.out.println("termination complete.");
    }

    @Override
    public void close() {
        this.siLAServerBase.close();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

