/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.hello_sila;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceGrpc;
import sila2.org.silastandard.core.silaservice.v1.SiLAServiceOuterClass;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderGrpc;
import sila2.org.silastandard.examples.greetingprovider.v1.GreetingProviderOuterClass;
import sila_java.library.core.discovery.SiLAServerDiscovery;
import sila_java.library.core.utils.SiLAErrors;
import sila_java.library.manager.SiLAManager;
import sila_java.library.manager.models.Server;
import sila_java.library.manager.server_management.ServerUtilities;

public class HelloSiLAClient {
    private GreetingProviderGrpc.GreetingProviderBlockingStub blockingStub;

    private void buildStub(ManagedChannel channel) {
        this.blockingStub = GreetingProviderGrpc.newBlockingStub((Channel)channel);
    }

    private void greet(String name) {
        GreetingProviderOuterClass.Get_StartYear_Responses startYear;
        GreetingProviderOuterClass.SayHello_Responses result;
        System.out.println("Will try to greet " + name + " ...");
        GreetingProviderOuterClass.SayHello_Parameters.Builder parameter = GreetingProviderOuterClass.SayHello_Parameters.newBuilder();
        try {
            result = this.blockingStub.sayHello(parameter.setName(SiLAFramework.String.newBuilder().setValue(name)).build());
        }
        catch (StatusRuntimeException e) {
            SiLAFramework.SiLAError siLAError = SiLAErrors.retrieveSiLAError((StatusRuntimeException)e);
            if (siLAError == null) {
                throw new RuntimeException("Not A SiLA Error: " + e.getMessage());
            }
            System.out.println(SiLAErrors.generateSiLAErrorString((SiLAFramework.SiLAError)siLAError));
            return;
        }
        System.out.println("Greeting: " + result.getGreeting().getValue());
        System.out.println("Will try to get start year...");
        try {
            startYear = this.blockingStub.getStartYear(GreetingProviderOuterClass.Get_StartYear_Parameters.newBuilder().build());
        }
        catch (StatusRuntimeException e) {
            SiLAFramework.SiLAError siLAError = SiLAErrors.retrieveSiLAError((StatusRuntimeException)e);
            if (siLAError == null) {
                throw new RuntimeException("Not A SiLA Error: " + e.getMessage());
            }
            System.out.println(SiLAErrors.generateSiLAErrorString((SiLAFramework.SiLAError)siLAError));
            return;
        }
        System.out.println("Start Year: " + startYear.getStartYear());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, TimeoutException {
        HelloSiLAClient client = new HelloSiLAClient();
        SiLAManager siLAManager = SiLAManager.getInstance();
        siLAManager.startDiscovery();
        siLAManager.blockUntilServerFound("HelloSiLAServer", Integer.MAX_VALUE);
        ManagedChannel serviceChannel = ServerUtilities.buildNewChannel((Server)((Server)siLAManager.getSiLAServersByName("HelloSiLAServer").get(0)));
        SiLAServiceGrpc.SiLAServiceBlockingStub serviceStub = SiLAServiceGrpc.newBlockingStub((Channel)serviceChannel);
        System.out.println("Found Features:");
        List featureIdentifierList = serviceStub.getImplementedFeatures(SiLAServiceOuterClass.Get_ImplementedFeatures_Parameters.newBuilder().build()).getImplementedFeaturesList();
        featureIdentifierList.forEach(featureIdentifier -> System.out.println("\t" + featureIdentifier.getFeatureIdentifier()));
        client.buildStub(serviceChannel);
        try {
            String user = "SiLA";
            client.greet(user);
        }
        finally {
            SiLAServerDiscovery.getInstance().stop();
            serviceChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
    }
}

