package sila_java.servers.multidrop;

import io.grpc.ManagedChannel;
import sila2.org.silastandard.SiLAFramework;
import sila2.org.silastandard.core.shakecontroller.v1.ShakeControllerGrpc;
import sila2.org.silastandard.core.shakecontroller.v1.ShakeControllerOuterClass;
import sila_java.library.core.discovery.SiLAServerDiscovery;
import sila_java.library.manager.SiLAManager;
import sila_java.library.manager.server_management.ServerUtilities;

import java.util.concurrent.TimeUnit;

/**
 * Client to call Multidrop Server
 */
public class MultidropClient {

    public static void main(String[] args) throws Exception {
        // Create Manager for clients and start discovery
        final SiLAManager siLAManager = SiLAManager.getInstance();
        siLAManager.startDiscovery();

        // Blocking call to find server, then connect to the first one found
        siLAManager.blockUntilServerFound(MultidropServer.SERVER_TYPE, Integer.MAX_VALUE);

        final ManagedChannel channel =
                ServerUtilities.buildNewChannel(siLAManager.getSiLAServersByName(MultidropServer.SERVER_TYPE).get(0));

        final ShakeControllerGrpc.ShakeControllerBlockingStub blockingStub =
                ShakeControllerGrpc.newBlockingStub(channel);

        // Call the server and try to shake
        try {
            blockingStub.shake(ShakeControllerOuterClass.Shake_Parameters.newBuilder()
                    .setDuration(SiLAFramework.Integer.newBuilder()
                            .setValue(1) // one second
                    ).build());
        } finally {
            SiLAServerDiscovery.getInstance().stop();
            channel.shutdown().awaitTermination(5, TimeUnit.SECONDS);
        }
    }
}