/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.multidrop;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.communication.CommunicationSocket;
import sila_java.library.core.communication.SerialCommunication;
import sila_java.library.core.communication.SynchronousCommunication;
import sila_java.servers.multidrop.MultidropDriver;
import sila_java.servers.multidrop.MultidropUtils;

class MultidropDriver {
    private static final Logger log = LoggerFactory.getLogger(MultidropDriver.class);
    private static final int INPUT_TIMEOUT = 5000;
    private static final int SAMPLING_TIME = 2000;
    private static final String DELIMITER = "\r\n";
    private final SynchronousCommunication serialCommunication = new SynchronousCommunication((CommunicationSocket)new SerialCommunication());
    private MultidropUtils.DeviceType type = null;
    private int _plateType = 0;

    MultidropDriver() {
    }

    void start() throws IOException {
        try {
            this.serialCommunication.open();
        }
        catch (IOException e) {
            log.info("Initial probing of serial port failed: " + e.getMessage());
        }
        this.serialCommunication.startHeartbeat(2000, () -> this.checkDeviceHealth());
        if (this.checkDeviceHealth()) {
            this.primePosition();
        }
    }

    boolean isDriverUp() {
        return this.checkDeviceHealth();
    }

    private boolean checkDeviceHealth() {
        try {
            this.getDeviceType();
            this.deviceTypeTestCondition();
            this.setPlateType();
        }
        catch (IOException | IllegalStateException e) {
            log.info(e.getMessage());
            return false;
        }
        return true;
    }

    private String sendReceive(String msg) throws IOException {
        return this.sendReceive(msg, 0L);
    }

    private String sendReceive(String msg, long additionalTimeout) throws IOException {
        String result = this.serialCommunication.sendReceive(msg, DELIMITER, 5000L + additionalTimeout);
        if (MultidropUtils.ERRORS.containsKey(result)) {
            throw new IOException(((MultidropUtils.MultiDropError)MultidropUtils.ERRORS.get((Object)result)).message);
        }
        return result.replaceAll("([\\r\\n\\t])", "");
    }

    void shake(int time) throws IOException {
        log.info("shake(" + time + ")");
        this.sendReceive("Z" + time, TimeUnit.SECONDS.toMillis(time));
    }

    void dispense(int volume, int columnStart, int columnEnd) throws IllegalArgumentException, IOException {
        log.info("dispense(" + volume + ", " + columnStart + ", " + columnEnd + ")");
        if (columnStart > columnEnd) {
            throw new IllegalArgumentException("Column start must be smaller that column end");
        }
        String result = this.sendReceive("S" + columnStart);
        log.info("1. Column [S]tart set: " + result);
        result = this.sendReceive("V" + volume);
        log.info("3. Dispensing [V]olume set: " + result);
        this.primePosition();
        int wells = columnEnd - columnStart + 1;
        log.info("   Start column: " + columnStart + " End column: " + columnEnd + " amount of columns: " + wells);
        for (int i = 0; i < wells; ++i) {
            int currentWell = i + columnStart;
            this.sendReceive("S" + currentWell);
            result = this.sendReceive("M");
            log.info(currentWell + ". Dispensing column " + currentWell + " set [M]: " + result);
        }
        this.primePosition();
    }

    private void primePosition() throws IOException {
        String msg = this.sendReceive("O");
        log.info("Primed: " + msg);
    }

    private void setPlateType() throws IOException {
        this.sendReceive("T" + String.valueOf(this._plateType));
        if (this._plateType == 0) {
            log.debug("Set plateType to 96-well plate");
        } else if (this._plateType == 1) {
            log.debug("Set plateType to 384-well plate");
        }
    }

    private void deviceTypeTestCondition() throws IllegalStateException {
        switch (1.$SwitchMap$sila_java$servers$multidrop$MultidropUtils$DeviceType[this.type.ordinal()]) {
            case 1: {
                log.debug("Device was tested. Passing test condition.");
                break;
            }
            default: {
                throw new IllegalStateException("Device type " + this.type.name() + " not supported!");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getDeviceType() throws IOException, IllegalStateException {
        String version = this.sendReceive("VER");
        log.debug("Version: " + version);
        if (version == null || version.isEmpty()) throw new IllegalStateException("Can not recognise Device Type");
        if (version.contains("MultidropCombi")) {
            log.info("Detected MultidropCombi device");
            this.type = MultidropUtils.DeviceType.MultidropCombi;
            return;
        } else if (version.contains("MdropDW")) {
            log.info("Detected MultidropDW device");
            this.type = MultidropUtils.DeviceType.MultidropDW;
            return;
        } else if (version.contains("MDMicro")) {
            log.info("Detected MultidropMicro device");
            this.type = MultidropUtils.DeviceType.MultidropMicro;
            return;
        } else {
            if (!version.contains("Mdrop384")) throw new IllegalStateException("Version " + version + " not supported!");
            log.info("Detected Multidrop384 device");
            this.type = MultidropUtils.DeviceType.Multidrop384;
        }
    }

    public static void main(String[] args) throws IOException {
        MultidropDriver driver = new MultidropDriver();
        driver.start();
        driver.dispense(50, 9, 12);
        if (args.length > 0 && args[0].equals("shake")) {
            driver.shake(Integer.parseInt(args[1]));
        }
        log.info("... finished");
    }
}

