package sila_java.servers.test_server.impl;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import lombok.extern.slf4j.Slf4j;
import sila2.ch.unitelabs.observablepropertytest.v1.ObservablePropertyTestGrpc;
import sila2.ch.unitelabs.observablepropertytest.v1.ObservablePropertyTestOuterClass;
import sila2.org.silastandard.SiLAFramework;

import java.util.ArrayList;
import java.util.List;

@Slf4j
public class ObservableProperty extends ObservablePropertyTestGrpc.ObservablePropertyTestImplBase {
    public static final int NB_RESPONSE = 10;

    @Override
    public void subscribeListString(ObservablePropertyTestOuterClass.Subscribe_ListString_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.Subscribe_ListString_Responses> responseObserver) {
        new Thread(() -> {
            final List<SiLAFramework.String> list = new ArrayList<SiLAFramework.String>() {{
                add(SiLAFramework.String.newBuilder().setValue("Element 0").build());
                add(SiLAFramework.String.newBuilder().setValue("Element 1").build());
                add(SiLAFramework.String.newBuilder().setValue("Element 2").build());
            }};

            try {
                for (int i = 0; i < ObservableProperty.NB_RESPONSE; ++i) {
                    list.add(SiLAFramework.String.newBuilder().setValue("Element " + list.size()).build());
                    responseObserver.onNext(ObservablePropertyTestOuterClass.Subscribe_ListString_Responses
                            .newBuilder()
                            .addAllListString(list)
                            .build()
                    );
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } catch (StatusRuntimeException ignored) {
                log.info("Subscription to observable property canceled.");
            }
        }).start();
    }

    @Override
    public void subscribeSingletonListString(ObservablePropertyTestOuterClass.Subscribe_SingletonListString_Parameters request, StreamObserver<ObservablePropertyTestOuterClass.Subscribe_SingletonListString_Responses> responseObserver) {
        try {
            responseObserver.onNext(ObservablePropertyTestOuterClass.Subscribe_SingletonListString_Responses.newBuilder()
                    .addSingletonListString(SiLAFramework.String.newBuilder().setValue("Best pattern").build())
                    .build());
        } catch (StatusRuntimeException ignored) {
            log.info("Subscription to observable property canceled.");
        }
    }
}
