package sila_java.servers.test_server.impl;

import io.grpc.stub.StreamObserver;
import lombok.extern.slf4j.Slf4j;
import sila2.ch.unitelabs.unobservablecommandtest.v1.UnobservableCommandTestGrpc;
import sila2.ch.unitelabs.unobservablecommandtest.v1.UnobservableCommandTestOuterClass;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.utils.SiLAErrors;

@Slf4j
public class UnobservableCommand extends UnobservableCommandTestGrpc.UnobservableCommandTestImplBase {
    public static final UnobservableCommandTestOuterClass.MakeCoffee_Responses MAKE_COFFEE_RESPONSE = UnobservableCommandTestOuterClass.MakeCoffee_Responses
            .newBuilder()
            .setResult(SiLAFramework.String.newBuilder().setValue("Your coffee is ready!").build())
            .build();
    public static final UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses COMPLICATED_RESPONSES =
            UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses
                    .newBuilder()
                    .setFirstResponse(SiLAFramework.String.newBuilder().setValue("Dead").build())
                    .setSecondResponse(SiLAFramework.String.newBuilder().setValue("Alive").build())
                    .build();
    public static final UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses THREE_DIMENSIONAL_STRUCT_RESPONSES =
            UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses
                    .newBuilder()
                    .setThreeDimensionalListResult(UnobservableCommandTestOuterClass.DataType_ThreeDimensionalString
                            .newBuilder()
                            .addThreeDimensionalString(
                                    UnobservableCommandTestOuterClass.DataType_TwoDimensionalString
                                            .newBuilder()
                                            .addTwoDimensionalString(UnobservableCommandTestOuterClass.DataType_OneDimensionalString
                                                    .newBuilder()
                                                    .addOneDimensionalString(SiLAFramework.String.newBuilder().setValue("000").build())
                                                    .build()
                                            ).build()
                            )
                    ).build();
    public static final UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses THREE_DIMENSIONAL_LIST_RESPONSES =
            UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses
                    .newBuilder()
                    .setThreeDimensionalStructResult(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct
                            .newBuilder()
                            .setFirstDimension(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct
                                    .newBuilder()
                                    .setSecondDimension(UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses.ThreeDimensionalStructResult_Struct.FirstDimension_Struct.SecondDimension_Struct
                                            .newBuilder()
                                            .setThirdDimension(SiLAFramework.String.newBuilder().setValue("111").build())
                                            .build())
                                    .build())
                            .build())
                    .build();

    @Override
    public void makeCoffee(UnobservableCommandTestOuterClass.MakeCoffee_Parameters request, StreamObserver<UnobservableCommandTestOuterClass.MakeCoffee_Responses> responseObserver) {
        if (request.getSugar().getValue()) {
            responseObserver.onError(SiLAErrors.generateExecutionError(
                    "SugarException",
                    "Sorry, there is no more sugar!",
                    "Buy some sugar or take your coffee without sugar")
            );
            return;
        }
        responseObserver.onNext(UnobservableCommand.MAKE_COFFEE_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void whyMakeItSimpleWhenYouCanMakeItComplicated(
            UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Parameters request,
            StreamObserver<UnobservableCommandTestOuterClass.WhyMakeItSimpleWhenYouCanMakeItComplicated_Responses> responseObserver) {
        responseObserver.onNext(UnobservableCommand.COMPLICATED_RESPONSES);
        responseObserver.onCompleted();
    }

    @Override
    public void threeDimensionalStruct(
            UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Parameters request,
            StreamObserver<UnobservableCommandTestOuterClass.ThreeDimensionalStruct_Responses> responseObserver) {
        responseObserver.onNext(UnobservableCommand.THREE_DIMENSIONAL_STRUCT_RESPONSES);
        responseObserver.onCompleted();
    }

    @Override
    public void threeDimensionalList(
            UnobservableCommandTestOuterClass.ThreeDimensionalList_Parameters request,
            StreamObserver<UnobservableCommandTestOuterClass.ThreeDimensionalList_Responses> responseObserver) {
        responseObserver.onNext(UnobservableCommand.THREE_DIMENSIONAL_LIST_RESPONSES);
        responseObserver.onCompleted();
    }
}
