package sila_java.servers.test_server.impl;

import io.grpc.stub.StreamObserver;
import lombok.extern.slf4j.Slf4j;
import sila2.ch.unitelabs.unobservablepropertytest.v1.UnobservablePropertyTestGrpc;
import sila2.ch.unitelabs.unobservablepropertytest.v1.UnobservablePropertyTestOuterClass;
import sila2.org.silastandard.SiLAFramework;
import sila_java.library.core.utils.SiLAErrors;

@Slf4j
public class UnobservableProperty extends UnobservablePropertyTestGrpc.UnobservablePropertyTestImplBase {
    public static final UnobservablePropertyTestOuterClass.Get_ListString_Responses LIST_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_ListString_Responses.newBuilder()
            .addListString(SiLAFramework.String.newBuilder().setValue("White"))
            .addListString(SiLAFramework.String.newBuilder().setValue("Rabbit"))
            .build();

    public static final UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses LIST_STRUCT_PAIR_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.newBuilder()
            .addListStructPairString(
                    UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct
                            .newBuilder()
                            .setKey(SiLAFramework.String.newBuilder().setValue("Unite"))
                            .setValue(SiLAFramework.String.newBuilder().setValue("Labs"))
                            .build()
            ).addListStructPairString(
                    UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses.ListStructPairString_Struct
                            .newBuilder()
                            .setKey(SiLAFramework.String.newBuilder().setValue("SiLA"))
                            .setValue(SiLAFramework.String.newBuilder().setValue("Standard"))
                            .build()
            ).build();

    public static final UnobservablePropertyTestOuterClass.Get_StructPairString_Responses STRUCT_PAIR_STRING_RESPONSE = UnobservablePropertyTestOuterClass.Get_StructPairString_Responses
            .newBuilder()
            .setStructPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct
                    .newBuilder()
                    .setPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Responses.StructPairString_Struct.PairString_Struct
                            .newBuilder()
                            .setKey(SiLAFramework.String.newBuilder().setValue("AKey").build())
                            .setValue(SiLAFramework.String.newBuilder().setValue("AValue").build())
                            .build())
                    .build())
            .build();

    public static final UnobservablePropertyTestOuterClass.Get_DataType_Responses DATA_TYPE_RESPONSE = UnobservablePropertyTestOuterClass.Get_DataType_Responses
            .newBuilder()
            .setDataType(UnobservablePropertyTestOuterClass.DataType_DataTypeString
                    .newBuilder()
                    .setDataTypeString(SiLAFramework.String.newBuilder().setValue("blah").build())
                    .build())
            .build();

    @Override
    public void getListString(UnobservablePropertyTestOuterClass.Get_ListString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ListString_Responses> responseObserver) {
        responseObserver.onNext(UnobservableProperty.LIST_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getListStructPairString(UnobservablePropertyTestOuterClass.Get_ListStructPairString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ListStructPairString_Responses> responseObserver) {
        responseObserver.onNext(UnobservableProperty.LIST_STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getStructPairString(UnobservablePropertyTestOuterClass.Get_StructPairString_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_StructPairString_Responses> responseObserver) {
        responseObserver.onNext(UnobservableProperty.STRUCT_PAIR_STRING_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getDataType(UnobservablePropertyTestOuterClass.Get_DataType_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_DataType_Responses> responseObserver) {
        responseObserver.onNext(DATA_TYPE_RESPONSE);
        responseObserver.onCompleted();
    }

    @Override
    public void getThrowException(UnobservablePropertyTestOuterClass.Get_ThrowException_Parameters request, StreamObserver<UnobservablePropertyTestOuterClass.Get_ThrowException_Responses> responseObserver) {
        responseObserver.onError(
                SiLAErrors.generateExecutionError(
                        "TestException",
                        "Test exception",
                        "Nothing to do, this will always throw an exception")
        );
    }
}
