/*
 * Decompiled with CFR 0.152.
 */
package sila_java.servers.test_server;

import io.grpc.BindableService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sila_java.library.core.utils.SocketUtils;
import sila_java.library.core.utils.Utils;
import sila_java.library.server_base.SiLAServerBase;
import sila_java.library.server_base.identification.ServerInformation;
import sila_java.library.server_base.utils.ArgumentHelper;
import sila_java.servers.test_server.TestServer;
import sila_java.servers.test_server.impl.ObservableCommand;
import sila_java.servers.test_server.impl.ObservableProperty;
import sila_java.servers.test_server.impl.UnobservableCommand;
import sila_java.servers.test_server.impl.UnobservableProperty;

public class TestServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TestServer.class);
    static final String SERVER_TYPE = "TestServer";
    private static final int SERVER_PORT = 50053;
    private static final int SERVER_PORT_RANGE = 256;
    private static final String UNOBSERVABLE_PROP_FEATURE = "features/UnobservablePropertyTest.xml";
    private static final String OBSERVABLE_PROP_FEATURE = "features/ObservablePropertyTest.xml";
    private static final String UNOBSERVABLE_CMD_FEATURE = "features/UnobservableCommandTest.xml";
    private static final String OBSERVABLE_CMD_FEATURE = "features/ObservableCommandTest.xml";
    private final SiLAServerBase siLAServerBase;

    public TestServer(@NonNull String interfaceName, int serverPort, @Nullable Path config) {
        if (interfaceName == null) {
            throw new NullPointerException("interfaceName");
        }
        try {
            1 featureDefinitions = new /* Unavailable Anonymous Inner Class!! */;
            ServerInformation serverInfo = new ServerInformation(SERVER_TYPE, "Server for test purposes", "www.unitelabs.ch", "v0.0");
            this.siLAServerBase = config == null ? SiLAServerBase.withoutConfig((ServerInformation)serverInfo, (Map)featureDefinitions, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new UnobservableProperty(), new ObservableProperty(), new UnobservableCommand(), new ObservableCommand()}) : SiLAServerBase.withConfig((Path)config, (ServerInformation)serverInfo, (Map)featureDefinitions, (int)serverPort, (String)interfaceName, (BindableService[])new BindableService[]{new UnobservableProperty(), new ObservableProperty(), new UnobservableCommand(), new ObservableCommand()});
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.siLAServerBase.close();
    }

    public static void main(String[] args) {
        ArgumentHelper argumentHelper = new ArgumentHelper(args, SERVER_TYPE);
        int serverPort = argumentHelper.getPort() != null ? argumentHelper.getPort() : SocketUtils.getAvailablePortInRange((int)50053, (int)50309);
        try (TestServer server = new TestServer(argumentHelper.getInterface(), serverPort, (Path)argumentHelper.getConfigFile().orElse(null));){
            Utils.blockUntilStop();
        }
        System.out.println("Server closed.");
    }
}

